var samplePageObj = {
  // 샘플 타이틀
  title: '툴팁과 힌트',
  subtitle: '셀 위에 마우스커서 오버시 보여지는 풍선도움말이나 힌트 기능에 대해 알아봅니다.',
  // 샘플 설명
  desc: '셀의 너비가 좁거나 내용이 많아 한눈에 내용을 보기 어려운 경우, 커서를 셀 위에 올렸을때 풍선도움말이나 셀의 너비를 늘려 내용을 보여주는 기능입니다.'
    + '<br>특정 셀의 내용과 다른 별도의 내용을 툴팁이나 힌트로 보여줄 수도 있습니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0,
      HeaderMerge: 3, // Header 영역만 머지
      PrevColumnMerge: 0,
      FitWidth: true
    },
    // 행,열 단위 공통 기능 설정
    Def: {
      Row: {
        ShowHint: 0,
        Tip: 0
      },
      Header: { Spanned: 1 },
      Col: { Spanned: 1 }
    },
    LeftCols: [
      {
        Header: [
          'No',
          'No'
        ],
        Type: 'Int',
        Width: 80,
        Align: 'Center',
        Name: 'SEQ'
      }
    ],
    Cols: [
      {
        Header: [
          '자금세탁ID',
          '자금세탁ID'
        ],
        Type: 'Text',
        Name: 'CPT_WASH_ID',
        Visible: 0
      },
      {
        Header: [
          '자금세탁사례',
          '출처유형'
        ],
        Type: 'Lines',
        Name: 'SOUR_TP_C_NM',
        Width: 100,
        CanEdit: 0,
        Wrap: 0
      },
      {
        Header: [
          '자금세탁사례',
          '제목'
        ],
        Type: 'Lines',
        Name: 'CPT_WASH_TI_NM',
        Width: 200,
        Wrap: 0
      },
      {
        Header: [
          '위험원인',
          '위험원인'
        ],
        Type: 'Lines',
        Name: 'RSK_CAS_CNTN',
        Width: 400,
        CanEdit: 0,
        Wrap: 0
      },
      {
        Header: [
          '국가',
          '관련국가위험유형코드'
        ],
        Type: 'Text',
        Width: 0,
        Name: 'REL_NAT_RSK_TP_C',
        Visible: 0
      },
      {
        Header: [
          '국가',
          '관련국가위험유형'
        ],
        Type: 'Text',
        Name: 'REL_NAT_RSK_TP_C_NM',
        Width: 150,
        CanEdit: 0
      },
      {
        Header: [
          '고객',
          '업종구분코드'
        ],
        Type: 'Text',
        Name: 'BZC_DSC',
        Visible: 0
      },
      {
        Header: [
          '고객',
          '업종구분'
        ],
        Type: 'Text',
        Name: 'BZC_DSC_NM',
        Width: 120,
        CanEdit: 0
      },
      {
        Header: [
          '고객',
          '고객특성코드'
        ],
        Type: 'Text',
        Name: 'CUS_CHR_C',
        Visible: 0
      },
      {
        Header: [
          '고객',
          '고객특성'
        ],
        Type: 'Text',
        Name: 'CUS_CHR_C_NM',
        Width: 120,
        CanEdit: 0
      },
      {
        Header: [
          '상품 및 서비스',
          '상품 및 서비스코드'
        ],
        Type: 'Text',
        Name: 'IV_C',
        Visible: 0
      },
      {
        Header: [
          '상품 및 서비스',
          '상품 및 서비스'
        ],
        Type: 'Text',
        Name: 'IV_C_NM',
        Width: 120,
        CanEdit: 0
      },
      {
        Header: [
          '채널',
          '거래채널코드'
        ],
        Type: 'Text',
        Name: 'ENT_CHAN_C',
        Visible: 0
      },
      {
        Header: [
          '채널',
          '거래채널'
        ],
        Type: 'Text',
        Name: 'ENT_CHAN_C_NM',
        Width: 100,
        CanEdit: 0
      },
      {
        Header: [
          '조회조건',
          '출처유형'
        ],
        Type: 'Text',
        Name: 'SOUR_TP_C'
      },
      {
        Header: [
          '조회조건',
          '관련전제범죄'
        ],
        Type: 'Text',
        Name: 'REL_PREM_CRIM_C'
      },
      {
        Header: [
          '조회조건',
          '의심거래유형'
        ],
        Type: 'Text',
        Name: 'ENT_CHAN_C'
      },
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><button class=\'mgr10\' onclick=\'sampleBtn(this)\'>툴팁 사용</button> <button class=\'mgr10\' onclick=\'sampleBtn(this)\'>힌트 사용</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    var btnObj = arguments[0];

    if (btnObj.innerText == '툴팁 사용') {
      sheet.Def.Row.Tip = 1;
      sheet.showMessageTime('툴팁이 활성화 되었습니다. 마우스 커서를 셀위에 올려보세요.', 1500);
      btnObj.innerText = '툴팁 비활성화';
    } else if (btnObj.innerText == '툴팁 비활성화') {
      sheet.Def.Row.Tip = 0;
      btnObj.innerText = '툴팁 사용';
    } else if (btnObj.innerText == '힌트 사용') {
      sheet.Def.Row.ShowHint = 1;
      sheet.showMessageTime('힌트기능이 활성화 되었습니다. 마우스 커서를 셀위에 올려보세요.', 1500);
      btnObj.innerText = '힌트 비활성화';
    } else if (btnObj.innerText == '힌트 비활성화') {
      sheet.Def.Row.ShowHint = 0;
      btnObj.innerText = '힌트 사용';
    }
  },

  // event구문
  event: {
    onShowHint: function (evtParam) {
      // 힌트가 보여질때 발생하는 이벤트
      console.log('%cIB %cSheet log:\n', 'color:red', 'color:black',
        'onShowHint:',
        '행:' + evtParam.row.id + ' 열:' + evtParam.col + ' 힌트 내용:' + evtParam.hint);
    },
    onShowTip: function (evtParam) {
      // 툴팁이 보여질때 발생하는 이벤트
      console.log('%cIB %cSheet log:\n', 'color:red', 'color:black',
        'onShowTip:',
        '행:' + evtParam.row.id + ' 열:' + evtParam.col + ' 툴팁 내용:' + evtParam.tip);
    }
  },

  // data
  data: [
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2005-3',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '1',
      LA_C: '05',
      NAT_C: 'CA',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '캐나다',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '선납보험금 납입 후 중도해약 환급금을 통한 불법 자금 현금화 TEST',
      BZC_DSC_NM: null,
      TR_CHR_C: '06',
      CUS_CHR_C_NM: null,
      CPT_WASH_CNTN: '캐나다의 마약불법상인이 80,000 미국달러에 해당하는 생명보험증서(life insurance policy)를 구매하였다. 그 증서는 자기앞수표(cashier&apos;s check)로 대형 생명보험회사 중개상(agent)을 통해서 구매되었다. 조사에 따르면, 그 고객은 증권을 사기위해서 쓰인 돈이 마약거래에서 번 돈임 알렸다고 한다. 이 점을 고려해서 그 중개상(agent)은 훨씬 더 높은 수수료(commission)를 부과했다고 한다. 그 후에 조사에 의해 밝혀진 바에 따르면, 이 거래가 있은지 3개월이 지나고 이 마약상은 이 생명보험 증권을 현금화 하였다고 한다.',
      CPT_WASH_ID: '00000000000000000108',
      CUS_CHR_C: null,
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '2',
      SUSPI_TRTP_C_NM: '무관업종 또는 의심스러운 재산에 대한 보험청약 거래',
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '불법으로 얻은 자금을 생명보험회사 중개상을 통해 선납으로 보험 가입 후 해지하여 자금세탁 할 위험',
      SUSPI_TRTP_C: '15',
      TR_SCL_AM: '.8',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2005-4',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'BE',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '벨기에',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자신의 돈으로 가입한 보험을 회사가 가입한 것으로 위장하여 자금 출처 은닉',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '03',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '한 남편과 부인이 연간보험료를 내는 생명보험을 각자의 명의 하에 가입했다. 만일 어느 한쪽의 배우자가 사망한다면, 다른 배우자가 그 보험의 수령인이 된다. 보험료를 내던 계좌의 주인은 보험 계약자들이 아니라 그들이 임원으로 있었던 외국의 회사인 것으로 밝혀졌다. 그러나 이 생명보험증권은 회사에 의해서가 아니라 이 커플이 개인적으로 체결한 것이다. 나중에 밝혀진 바에 의하면 이 시나리오는 이 커플이 연관 되어 조직화된 세금사기에서 나온 돈의 불법적인 출처를 감추기 위한 의도였음이 드러났다.',
      CPT_WASH_ID: '00000000000000000109',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '국가부패지수가 높은 국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '4',
      RSK_CAS_CNTN: '자신의 돈으로 가입한 보험을 회사가 가입한 것으로 위장하여 세금사기를 할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1',
      RSK_CAS_CNTNTip: '별도 툴팁 내용입니다.',
      RSK_CAS_CNTNHintValue: '별도 힌트 내용입니다.',
      RSK_CAS_CNTNColor: '#DDDDFF'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '06',
      SOUR_DTL_CNTN: 'FATF-2009b-6',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'BE',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '벨기에',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '비영리단체 계좌의 다수 거래를 이용한 테러자금 이동',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '범죄조직 및 테러단체',
      CPT_WASH_CNTN: '한 은행이 테러와 연관 있는 고객을 식별하기 위해 데이터베이스를 확인하였고, 그 은행에 계좌를 가진 고객 중 유럽의 B국가가 주소지인 사무실을 소유한 한 비영리조직 테러리즘 목록에 있음을 확인하였다. 이 조직의 계좌는 몇 년 전에 만들어 졌고, 그간 별 다른 거래가 없다가 갑자기 2002년 1월 1일부터 매우 활발한 활동이 시작되었다. 이 계좌의 거래는 몇몇 사람들에 의해 여러 번의 현금 예금으로 이루어졌고, 그 총액은 상당했다. 그 후 돈은 현금으로 인출되었다.\r\n\r\nFIU에 의해 다음과 같은 사실이 밝혀졌다.\r\n•B국가에 있는 국가안보청으로부터 받은 정보를 바탕으로, FIU는 이 비영리조직이 B국가에서 중동으로 싸우러 갈 사람을 모집하고, 보내는 목적으로 만들어진 있는 수많은 연락책 중 하나라고 결론 내렸다.\r\n•또한 이 조직의 계좌의 signature authorities중 2~3개가 테러집단과 연결되었었다.\r\n이 사건은 아직 사법처리 중이다.',
      CPT_WASH_ID: '00000000000000000115',
      CUS_CHR_C: '05',
      REL_NAT_RSK_TP_C_NM: 'UN 제재국가 및 테러지원국',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '테러자금으로 의심되는 거래',
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '2',
      RSK_CAS_CNTN: '비영리 단체를 이용한 테러자금 송금 위험',
      SUSPI_TRTP_C: '16',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'Egmont Case 100_50',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: null,
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '12',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '유럽',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '위조 신분증에 의한 계좌 개설 후 자금세탁 / 담보 과대 평가를 통한 대출 사기',
      BZC_DSC_NM: '부동산중개업',
      TR_CHR_C: '09',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '<창고접수내용>\r\n유럽 시민권자인 Hery는 이민권자를 위한 부동산 중개매매업자로 일함. Hery는 부동산을 찾아 고객에 대한 적정한 담보대출을 정하여 가치산정보고서를 만들었으나, 시장가격보다 상당히 높게 평가됨. 담보대출이 승인된 후 Hery는 시장가격으로 자신이 구입했으며 같은날 가치산정보고서의 가격으로 고객에게 부동산을 매매하여 위험없이 상당한 이익을 남김.\r\n\r\n<수사결과>\r\nFIU는 보고서를 경찰에게 전달하였으며 경찰은 고객의 불만을 수집하여 금융범죄 조사를 진행한 결과 Hery는 850,000달러를 만들었으며 불법적으로 얻은 수익의 공제비용은 640,000달러 이상 되었음. 종합적으로 그는 약 150명에게 사기를 침.',
      CPT_WASH_ID: '00000000000000000116',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '국가부패지수가 높은 국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '2',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '4',
      RSK_CAS_CNTN: '부동산 평가자가 부동산에 대한 과대 평가를 통해 대출 사기에 노출될 위험\r\n위조신분증을 통해 개설된 계좌 및 제3자의 계좌를 이용한 자금세탁의 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '8.5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: 'Egmont Case 100_61',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: null,
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '알 수 없음',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '다자 간의 거래를 통한 범죄 행위를 통해 형성된 자금에 대한 은닉',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '범죄조직 및 테러단체',
      CPT_WASH_CNTN: '<창구 접수 내용>\r\n 브랜든, 레옹, 퍼디난드는 은행털이를 했음. 범행의 목표는 멀리 떨어진 마을의 작은 금융기관이었고, 대략 27만 달러의 복합 통화를 훔쳤음. 그들은 동일한 몫으로 나누기로 합의했고, 개인당 9만 달러에 해당하는 돈을 가졌음. 브랜든은 다른 나라에 사는 그의 사촌인 로랜스에게 돈을 맡겨 안전을 도모했음. 돈을 세탁하기 위해서 브랜든은 은행 계좌를 개설했고, 돈을 넣어두었으며, 로랜스의 해외계좌로 송금을 요청했음. 로랜스는 2달 후에 브랜든의 계좌로 대출 형식으로 환급했음.\r\n\r\n<수사 결과>\r\nFIU와 경찰 조사에 따르면 브랜든이 무기를 강탈한 전력을 알아냈으며, 레옹, 퍼디난드와의 관계도 밝혀냈음. 더욱이, 브랜든이 자금세탁을 시작하는 과정이 은행강탈 몇 일 후였던 것을 밝혀냈고, 보증금은 어음으로 처리되었으며, 자금유용에 있어서 쓰인 통화도 동일한 것으로 밝혀졌음. 관계당국은 유통된 자금이 강탈한 돈에서 브랜든의 몫이었으며, 그는 돈을 이중세탁으로 인해 정상적인 절차로 보이려 했다는 것도 밝혔음.\r\n 결과적으로 관계당국은 1심 재판에서 3명의 범인들을 상대로 재판이 진행 중이며, 그들의 은행계좌는 동결되었음.',
      CPT_WASH_ID: '00000000000000000117',
      CUS_CHR_C: '05',
      REL_NAT_RSK_TP_C_NM: 'UN 제재국가 및 테러지원국',
      ASET_SCL_C: '2',
      TR_SCL_C: '2',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '2',
      RSK_CAS_CNTN: '범죄 행위를 통해 형성된 자금에 대한 은닉 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '2.7',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2005-5',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'IM',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '맨섬',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '제3자를 통한 전신송금을 이용한 마약밀매자금 세탁',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '03',
      CUS_CHR_C_NM: '범죄조직 및 테러단체',
      CPT_WASH_CNTN: '마약밀수 조사에 의한 정보에 따르면, 맨 섬과 the Bailiwick of Guernsy에 있는 많은 보험회사들이 수많은 보험증서 대금을 마약수익금으로 받은 것이 알려졌다. 마약 수익금이 2001년 전까지 상당한 시간동안 생명보험 증서에 입금된 것이 확인되었다. 이러한 보험증서들은 대부분 컬럼비아와 다른 남미 관할지역에서 활동하는 한명의 브로커에 의해서 체결되었다. 마약수익금이 들어간 보험 증서들은 여러 가지 방법으로 돈을 받았다. 첫 번째로, 가장 흔한 방법은 제 3자를 통한 전신송금이다. 많은 예에서 브로커의 명에 따라 대량 전신송금이 한 기관으로 보내어 진다.\r\n일단 기관의 계좌로 보내지면, 브로커는 어떻게 돈을 나누고, 어떤 계좌로 입금시킬지 자세한 정보를 제공해주었다. 보험업자는 또한 제 3자의 수표나 구조화된 우편환으로 지불받았다. 마지막으로 몇몇의 보험계약은 브로커의 수수료 계좌에서 돈을 받아 지불된다. 이 시나리오에서는 브로커는 컬럼비아에 있는 손님으로부터 현금을 받고, 그의 사업상 운영하는 계좌에서 나온 돈으로 손님의 보험에 돈을 넣어준다.',
      CPT_WASH_ID: '00000000000000000110',
      CUS_CHR_C: '05',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '원격지거래',
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '불법으로 얻은 자금(마약밀매)을 브로커를 통해 조세피난처의 보험회사에 가입된 범죄자의 보험증서에 입금하여 자금을 세탁한 위험',
      SUSPI_TRTP_C: '02',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2009a-2',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'AT',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '14',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '오스트리아',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '합리적 사유가 없는 다수 주식 거래 및 고수익 계좌',
      BZC_DSC_NM: '비은행 금융기관(은행 이외 제2금융권)',
      TR_CHR_C: '09',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '오스트리아 인터넷 은행은 금융정보분석기구(FIU)에 수상한 은행계좌가 있다고 보고했다. 이 의혹은 여러 명의 고객의 수상한 활동에서 제기되었는데, 예를 들면 하루 안에 높은 이익을 보거나, 주식의 구매와 판매가 하루차이로 일어나는 것, 같은 비밀번호의 공유 등이었다.\r\n\r\n6백만 달러에 해당하는 주가수입을 올린 회사매각과 관련해서 많은 증권거래가 있었다. 이 판매는 나중에 내부자 거래에 의한 것으로 밝혀졌다. 여기에는 오스트리아 계좌가 주식의 거래에 사용되었다.\r\n철저한 조사로 몇 개의 계좌가 이 증권거래와 연관이 있는 것이 밝혀졌다. 이 계좌들의 주인은 동시간의 주식 구입과 판매로 아주 짧은 시간 안에 큰 수익을 거두었다. 금융정보분석기구(FIU)는 즉시 검찰에 자금세탁의 가능성과 내부자거래혐의를 알렸다.',
      CPT_WASH_ID: '00000000000000000111',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: 'AML 취약국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '2',
      SUSPI_TRTP_C_NM: '거액 입금 후 당일 또는 익일 중 인출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '3',
      RSK_CAS_CNTN: '주식 내부자 거래 위험',
      SUSPI_TRTP_C: '06',
      TR_SCL_AM: '60',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2009a-8',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'CA',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '카나다',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '워시 트레이딩을 이용한 주가조작',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '세 사람들이 워시트레이드관련 의심을 받았다. 이 사람들은 분명한 이유 없이 세 개의 상장기업의 주식을 사고팔았다. 이 세 명은 각기 다른 증권회사에 계좌를 가지고 있었다.\r\n\r\n서로 동료인 이 세 명은 A, B, C 회사의 주식을 구매하고, 짧은 시간이 지난 후 바로 되팔고 있었다. 이 사람들 중의 한 명은 A회사의 CEO로 알려져 있었고, 다른 두 명은 B회사의 고위관리로 알려져 있었다. A회사는 B회사, C회사와 연관이 되어있었다.\r\n이 그룹은 각기 증권회사에 있는 개인 계좌를 통해서 회사주식거래를 하였다. 이 세 명은 같은 시간에 같은 거래를 하였다. 이 셋은 사실 구입과 판매 음모계획을 나눠서 하고 있었기에, 구조화이라고 불리는 자금 세탁 기술과 비슷한 기술을 사용했다고 할 수 있다. 이 판매로부터 얻은 수익금은 개인 증권계좌로 입금되었고, 재빨리 동일인이나 대리인으로 의심되는 사람들의 은행계좌로 옮겨졌다.',
      CPT_WASH_ID: '00000000000000000112',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '빈번한 입출금(입출고)',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '중개인을 이용하여 주식을 동시에 사고 팔아 거래를 하는 척 하여(워시트레이드) 주가조작의 위험',
      SUSPI_TRTP_C: '12',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: 'FATF-2009a-11',
      REL_FNC_CO_C: '03',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'IL',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '이스라엘',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '페이퍼 컴퍼니 계좌를 이용한 투자 및 대출 명목 자금의 다수 이체 ',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '09',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'N씨는 자금세탁을 목적으로 증권거래소에서 거래되는 상장명목회사 A를 구매하여 주식가격을 조작하고, 별다른 이유 없이 자금을 B와 C회사의 계좌에 입금시킨 후 다시 출금해간 혐의를 받았다. \r\nN씨는 현금으로 두 개의 수표를 구매하여, 인수합병을 도와주는 로펌과 상장명목회사 A에게 주었다. N씨는 은행에게 투자자들에게 받은 현금이라고 보고하였지만 그는 투자자들에 관련 정보를 제공하는 것은 꺼려했다.\r\nN씨가 은행수표를 구매하고 1주가 흐른 후, A회사의 81% 주식이 N씨의 허수아비로 알려진 M씨에 의해서 구매되었다. 또한, M씨가 구매한 주식의 50%는 제 3자들을 대신한 것으로 알려졌지만 이 거래와는 아무런 연관이 없는 사람들이었다.  두 달 뒤, 남은 주식들은 O씨와 N씨의 나머지 가족들에게 팔렸다.\r\n회사 인수 후, A회사는 이 외국회사에 국제송금의 방법을 통해서 자금을 빌려주고, 이 대출은 짧은 시간 뒤에 그 외국회사에 의해서 운영되는 외국계좌를 이용해서 상환되었다.\r\n인수 몇 달 후에, 자금은 다양한 방법을 이용해서 인출되었다. 또한 이 회사는 파생상품에 대한 투자로 인해서 수백만의 이스라엘 셰켈을 잃었다고 보고했다.',
      CPT_WASH_ID: '00000000000000000113',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '2',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '자금세탁을 위하여 페이퍼 컴퍼니를 구매하고, 회사 명의를 속이기 위해 바지 사장에게 주식을 양도한 뒤 해외의 회사에 투자 및 대출 명목으로 자금을 이체하고, 이 이체한 자금을 다른 계좌로 돌려받는 방식을 이용한 자금세탁위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: '10',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2009a-12',
      REL_FNC_CO_C: '03',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'US',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '미국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '가명으로 개설한 3국의 증권회사 계좌를 이용한 재산 은닉',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '09',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '자산동결명령의 한 대상자가 제 3국에 있는 증권회사에 계좌를 개설했다. 이 제 3국의 회사는 통합계좌를 통해서 주식거래를 대신해서 수행할 때, 제재 받는 당사자를 위해서 가명을 사용하기로 동의하였다. 따라서 통합계좌의 주식 소유권자가 누군지 감출 수 있었다.',
      CPT_WASH_ID: '00000000000000000114',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: 'AML 취약국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '원격지거래',
      REL_PREM_CRIM_C: '07',
      REL_NAT_RSK_TP_C: '3',
      RSK_CAS_CNTN: '가명으로 개설한 3국의 증권회사 계좌를 이용한 재산 은닉 위험',
      SUSPI_TRTP_C: '02',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '재산국외도피',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: 'FATF-2005-1',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'BE',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '벨기에',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '선납보험금 납입 후 중도해약 환급금을 통한 불법 자금 증여',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '01',
      CUS_CHR_C_NM: '범죄조직 및 테러단체',
      CPT_WASH_CNTN: '벨기에에 거주하는 사기로 파산한 한 용의자가 현금을 내고 수표로 인출해서 변호사에게 주기 위해서 가족명의의 계좌를 이용했다. 변호사는 수표로 된 그 돈을 다시 가족들에게 주었고, 나머지 돈들은 용의자의 일시불 생명보험을 구매하는데 사용되었다. 그 후 이것은 즉시 창구를 통하여 중도 해약되었고, 중도해약 환급금은 가족들의 계좌로 들어갔다.',
      CPT_WASH_ID: '00000000000000000107',
      CUS_CHR_C: '05',
      REL_NAT_RSK_TP_C_NM: 'AML 취약국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '무관업종 또는 의심스러운 재산에 대한 보험청약 거래',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '3',
      RSK_CAS_CNTN: '선납 보험을 이용한 자금세탁 위험',
      SUSPI_TRTP_C: '15',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2005-1',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '선납보험금 납입 후 중도해약 환급금을 통한 불법 자금 증여',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 357억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000314',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2005-3',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '선납보험금 납입 후 중도해약 환급금을 통한 불법 자금 현금화',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 358억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000315',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.8십만불',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2005-4',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자신의 돈으로 가입한 보험을 회사가 가입한 것으로 위장하여 자금 출처 은닉',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 359억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000316',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2009a-2',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '합리적 사유가 없는 다수 주식 거래 및 고수익 계좌',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 361억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000318',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '거액 입금 후 당일 또는 익일 중 인출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '06',
      TR_SCL_AM: '60십만불',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2009a-8',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '워시 트레이딩을 이용한 주가조작',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 362억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000319',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2009a-11',
      REL_FNC_CO_C: '03',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '페이퍼 컴퍼니 계좌를 이용한 투자 및 대출 명목 자금의 다수 이체',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 363억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000320',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '10십만불',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2009a-12',
      REL_FNC_CO_C: '03',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '가명으로 개설한 3국의 증권회사 계좌를 이용한 재산 은닉',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 364억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000321',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '원격지거래',
      REL_PREM_CRIM_C: '07',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '02',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '재산국외도피',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2009b-6',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '비영리단체 계좌의 다수 거래를 이용한 테러자금 이동',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 365억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000322',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'FATF-2005-5',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '제3자를 통한 전신송금을 이용한 마약밀매자금 세탁',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 360억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000317',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '원격지거래',
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '02',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'Egmont Case 100_50',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '위조 신분증에 의한 계좌 개설 후 자금세탁 / 담보 과대 평가를 통한 대출 사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 366억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000323',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '8.5십만불',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'Egmont Case 100_61',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'FATF 및 Egmont Group 사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '다자 간의 거래를 통한 범죄 행위를 통해 형성된 자금에 대한 은닉',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 367억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000324',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '2.7십만불',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '1',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '1'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신) 취득경위가 의심스러운 거액예금을 담보로 하는 대출 거래 ',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'A은행 B지점에 평소 거래가 없던 김○○가 C은행에서 발행한 자기앞수표 1억원권 5매 5억원을 소지하고 내점하여 동 자금으로 정기예금을 신규 가입하였음. 며칠 후 다시 내점하여 동 정기예금을 담보로 3억원 대출을 신청하였음. 자금의 사용처 등 문의에 대해 답변을 회피하였으며, 대출금을 현금으로 전액 출금하여 D은행 정○○ 명의의 계좌로 송금한 바, 김○○의 직업, 평소 거래상황 등을 볼 때 자금이 거액이고, 예금 후 단시일 내에 대출을 받아 제3자에게 현금으로 송금한 점으로 볼 때 자금출처 등이 의심스러워 보고함.',
      CPT_WASH_ID: '00000000000000000035',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '예/적금담보대출은 대출절차가 비교적 간편한 점을 이용하여 자금세탁이 발생할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신) 취득경위가 의심스러운 거액예금을 담보로 하는 대출 거래 ',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'A은행 B지점에 평소 거래가 없는 고객 최○○가 타행에서 김○○에 의해 송금된 3억원을 인출하여 동 자금으로 정기예금을 신규 가입하였음. 며칠 후 최○○은 다시 내점하여 급히 자금이 필요하다고 말하면서 3억원의 대출을 요청한 바, 이자부담을 감안할 때 단기간에 상환되지 않으면 고객에게 이자면에서 불리하다고 설명하여도 관계없다고 하며 대출을 요청하였음.\r\n예금자원이 제3자로부터 송금되어 온 바, 최○○의 직업을 감안해 볼 때 거액의 자금을 받는 이유에 의심이 있고, 대출자금의 용도에 대해서도 명확히 답변하지 않는 한편, 대출자금도 합당한 이유 없이 전액 현금으로 출금하여 의심스러워 보고함.',
      CPT_WASH_ID: '00000000000000000036',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '정기예금을 담보로 대출받은 거액의 현금이 자금세탁에 이용될 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '3',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신) 취득경위가 의심스러운 거액예금을 담보로 하는 대출 거래 ',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'A은행 B지점에 평소 거래가 없던 갑과 을이 내점하여 갑 명의로 타지점에서 개설된 5억원의 정기예금통장을 제시하면서 을 명의로 4억원의 대출을 신청하였음. 갑과 을의 관계는 다소 어색해 보였으며, 대출금은 출금하여 제3자인 병의 C은행 계좌에 현금으로 송금한 바, 담보제공자인 갑과 차주인 을의 관계가 담보를 제공할 만한 경제적 합리성이 없고, 대출금을 전액 현금으로 처리하여 제3자에게 송금한 바, 예금자금의 출처 및 전체적인 거래형태가 의심스러워 보고함.',
      CPT_WASH_ID: '00000000000000000037',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '정기예금을 담보로 타인명의로 거액을 대출받아 현금으로 인출 뒤, 제3자에게 다시 송금하여 자금출처를 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '4',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: null,
      ISR_C: null,
      COP_CHR_C: null,
      SOUR_DTL_CNTN: 'TEST 사례',
      REL_FNC_CO_C: null,
      RNDA_DSC: null,
      IV_C_NM: null,
      DWL_TP_C: '1',
      LA_C: null,
      NAT_C: null,
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: null,
      IV_C: null,
      XLS_SQNO: null,
      JOB_DSC: null,
      REL_NAT_NM: 'TEST 사례',
      ENT_CHAN_C_NM: null,
      CPT_WASH_TI_NM: 'TEST 사례',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: null,
      CPT_WASH_CNTN: 'TEST 사례',
      CPT_WASH_ID: '00000000000000000214',
      CUS_CHR_C: null,
      REL_NAT_RSK_TP_C_NM: null,
      ASET_SCL_C: null,
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: null,
      RSK_CAS_CNTN: 'TEST 사례',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: null,
      PYM_CHAN_C: null,
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: null,
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'KoFIU사례_연차보고서\r\n(2007)\r\nP.88~89',
      REL_FNC_CO_C: '06',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '08',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '건설업체대표의 불법대출 사례',
      BZC_DSC_NM: '건설업',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '○○은행의 B건설 계좌에서 56억원을 인출하여 최○○ 계좌에 16억원, 양○○ 계좌에 30억원, 수취인 불명의 계좌에 10억원을 입금하고, 당일 임○○가 양○○ 계좌에서 20억원을 현금 인출하여 10억원을 황○○ 계좌에 입금하였다. 또한, 양○○가 F개발에서 본인계좌로 입금한 20억원을 인출하여 18억원은 B건설을, 2억원은 G개발을 송금의뢰인으로하여 ○○저축은행 계좌에 송금하였으며, 며칠 후 김○○가 J건설계좌에서 4,400만원을 인출하여 K홀딩스 명의로 저축은행 계좌에 송금하였다.\r\n\r\n[수사/조사 결과]\r\n송○○는 아파트 및 상가 신축공사와 관련하여 ○○ 저축은행으로부터 313억원 상당을 대출받은 후, 동 대출에 대한 사례비 명목으로 저축은행 임직원인 정○○ 등에게 1억원을 송금하였으며, 저축은행 임직원 이○○는 공모하여, 위 송○○가 M개발을 설립하여 아파트 설립건에 대하여 대출을 부탁하자,  확인절차 없이 36억2,000만원을 대출해 준 것을 비롯하여 총 176억5,000만원 상당을 대출하여 은행에 손해를 가하여 기소되었다.',
      CPT_WASH_ID: '00000000000000000001',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '빈번한 입출금(입출고)',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 자금력이 의심되는 법인의 불법대출 및 법인자금 횡령으로 조성된 불법자금을 세탁할 위험',
      SUSPI_TRTP_C: '12',
      TR_SCL_AM: '313',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 부활 후 해약 또는 고액의 계약대출을 실행하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '04',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n중소기업을 운영한다고 자신을 소개한 고객이 고수익 보험 상품에 투자를 목적으로 고액의 보험계약을 체결하였음. 잘 유지되던 보험계약이 고객의 사정이 어려워져 보험료를 납입하기가 힘들다는 이유로 실효가 되었음.\r\n한동안 연락이 없다가 경과기간의 보험료를 전액 납입하며 부활을 요청하여 계약을 계속 유지할 의사가 있다고 판단했으나 고객은 얼마 지나지 않아 합리적인 이유 없이 계약을 해약하려 하여 담당 설계사가 해약 시 손해를 많이 볼 수 있음을 설명하고 그 이유를 묻자 갑자기 자금이 필요하다고만 말하고 더 이상 답변을 하지 않았음',
      CPT_WASH_ID: '00000000000000000004',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 보험 실효 후 미납된 납입금을 납부하면 부활하는 보험제도를 이용하여 자금을 세탁할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 부활 후 해약 또는 고액의 계약대출을 실행하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '04',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]중소기업 임원인 고객이 잘 유지되어 오던 고액의 보험료를 납입하지 않아 계약 실효가 되었음. 설계사가 알아 본 바로는 고객의 직장, 경제적상황 등에 비추어 보험료를 납입하지 못할 특별한 이유가 없었고 1년이 지나 연락이 와서 경과기간의 보험료를 전액 납입하며 부활을 요청하여 고객의 요구대로 계약을 부활시했는데 갑자기 돈이 필요하다며 고액의 계약대출을 실행하였고 그 후 보험료를 납입하지 않아 다시 실효가 되었으며 대출금은 환급금으로 충당되었음',
      CPT_WASH_ID: '00000000000000000005',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 보험 상품의 실효, 부홀을 반복한 후 고액대출금을 환급금으로 충당하여 자금을 세탁할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 고액의 보험을 가입하면서 자금세탁방지제도에 관하여 문의하는  거래(I)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '01',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n거액 일시납 등의 계약을 가입하면서 "요즘 거액을 맡기면 괜히 불법적인 거래처럼 본다"는 등과 함께 자금세탁방지제도가 무엇인지, 관련 법규가 어떤 것이 있는지, 법을 위배했을 경우 어떤 처벌 등을 받는지에 관하여 물어보면서, 자기가 고액의 보험계약을 하는 것은 금융기관 등에서 수행하는 혐의거래 보고의 대상이 아닌 정상적인 거래이므로 보고하지 말아줄 것을 요청하였음',
      CPT_WASH_ID: '00000000000000000006',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 고객이 불법적인 자금거래에 연관되거나 세탁을 할 의도로 자금세탁에 알아보면서 의심고객으로 보고 되는것을 회피할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 고액의 보험을 가입하면서 자금세탁방지제도에 관하여 문의하는 거래(Ⅱ)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n자금세탁의 경우 통상 은행을 통해서 이루어지는 것으로 알고 있으나 보험사에서도 자금세탁 혐의거래보고를 하고 있는지, 그리고 실제 그런 경우가 있었는지 등의 사례에 관해 단순히 흥미 있다는 식으로 물어보았음',
      CPT_WASH_ID: '00000000000000000007',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 고객이 불법적인 자금거래에 연관되거나 세탁을 할 의도로 자금세탁에 알아보면서 의심고객으로 보고 되는것을 회피할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '3',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 경제적 능력이 의심되는 보험계약자가 거액의 보험료를 일시에 납입하고, 만기 또는 사망시 수익자를 이해관계 없는 제3자로 지정한 경우',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n자영업을 한다는 보험계약자가 거액의 일시납 생명보험에 가입하면서 피보험자는 본인으로 하고, 만기시까지 본인이 생존함으로써 수령하는 만기보험금 뿐만 아니라 본인의 사망시 수령하는 보험금까지도 이해관계가 없는 제3자를 수익자로 지정한 보험계약을 체결하였음.\r\n청약서상에 기재된 보험계약자의 직업 등 신원사항에 비추어 판단할 때 거액의 보험료를 일시금으로 납입할만한 경제적 능력이 의심되었으며, 계약체결 과정에서 거액의 보험을 가입하면서 수익자를 일반적인 보험계약과 다르게 지정한 특별한 이유가 있느냐는 담당직원의 질문에 불쾌감을 표시함',
      CPT_WASH_ID: '00000000000000000106',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '무관업종 또는 의심스러운 재산에 대한 보험청약 거래',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 지3자가 보험계약자에게 보험료를 제공하고 만기시에 제3자 본인이 보험금을 수령하도록하는 과정에서 자금을 세탁할 위험',
      SUSPI_TRTP_C: '15',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)경제적 합리성 없이 제3자의 부동산을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '기존 거래처인 고객이 평소 가까이 알고 지내는 친구라는 자와 함께 내점하여 거액의 대출을 신청하였으며 고객은 자신의 금융거래 상황 및 자산정도 등으로는 거액의 대출이 어렵다는 것을 알고 친구가 소유하고 있는 부동산을 담보로 제공하겠다고 하면서 등기부등본, 등기권리증 등 관련서류를 제출하였음. 고객에게 자금사용처 등을 문의한 바, 사업상 급히 필요하다는 답변만 되풀이하고 금리 등 대출 조건이 다소 불리하더라도 좋으니 대출이 이루어질 수 있도록 해달라고 거듭 부탁하였음. 동행한 친구는 영업점과는 전혀 거래가 없었고 특별한 직업도 없는 것으로 파악되었으며 고객과 그다지 친분관계도 없어 보였음. 또한 담보로 제공된 부동산은 수일 전에 취득한 것으로 확인되었음.',
      CPT_WASH_ID: '00000000000000000039',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '불법수익으로 제3자명의로 부동산을 취득한 뒤 담보대출로 자금출처를 은닉할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)경제적 합리성 없이 제3자의 부동산을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '거래가 없던 고객이 여러 사람을 동행하고 내점하여 제3자의 부동산을 담보로 거액의 대출을 신청하였음. 담보로 제공된 부동산의 소유자는 20대 초반이며, 최근에 구입한 것으로 확인되었음. 고객에게 자금의 사용처 등을 문의 한 바, 사업상 부채상환자금이라고만 답변하였으며, 이들은 서로 친분관계가 없어 보였고 상호 이해관계가 있는 듯 언행을 조심스럽게 하였음.',
      CPT_WASH_ID: '00000000000000000040',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '불법수익으로 취득한 재산을 경제적으로 합리성 없는 제3자에게 댐보로 제공하여 자금출처를 은닉할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)대표이사가 동일한 외감대상 규모 미만의 소규모 법인으로 합리적 이유없이 동 법인상호간 담보제공하고 대출하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '동일인이 관련업종이 상이한 소규모의 다수 법인을 경영하면서 동 법인들 상호간 이루어진 물품용역 서비스 등의 거래대금 지급을 이유로 법인상호간이나 다른 법인의 재산을 담보로 하는 대출을 요청하였으나 대표자가 대출금의 용도 등에 대하여 명확한 답변을 회피하는 등 자금의 사용처 및 담보제공 사유가 불분명하였음.',
      CPT_WASH_ID: '00000000000000000041',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '법인 간의 위장거래를 통해 불법자금을 조성하고, 그 과정에서 대출 신청법인이 자금세탁의 경로로 이용될 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)대표자에게 실질적 경영권이 없는 것으로 의심되거나 위장 법인이  합리적 이유 없이 거액을 대출받는 거래 1',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '평소 거래가 적은 법인이 동 법인 소유의 담보를 제공하고 거액의대출을 신청한 바, 대표자에게 자금용도 등에 대하여 문의하였으나 기계구입자금 또는 회사의 운전자금이 부족하여 긴급하다는 개괄적인 답변으로 일관할 뿐 구입기계에 대한 지식이 거의 없거나 세부적인 운전자금 용도에 대해 전혀 언급하지 않았음. 또한 금리 등 대출조건에 대해서는 별다른 관심이 없었으며, 무조건 대출이 이루어질 수 있도록 해 달라고 거듭 부탁하였고 대출 심사를 위해 회사를 방문해 본 바, 동 대표자는 부재중이고, 직원들은 실질적인 대표자로 보이는 제3자의 지시를 받아 업무를 수행하는 것으로 보였음.',
      CPT_WASH_ID: '00000000000000000042',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '대표자가 실질적 경영권을 행사하지 않는 법인을 담보로 거액의 대출을 받아 자금출처를 은닉할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)대표자에게 실질적 경영권이 없는 것으로 의심되거나 위장 법인이  합리적 이유 없이 거액을 대출받는 거래 2',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '평소 거의 거래가 없던 법인이 부동산을 담보로 대출을 신청하였음. 상기 법인은 설립 된지는 몇 년이 지났으나, 설립 후 현재까지 매출액은 미미하였으며, 자금용도에 대해서도 운영자금이라고만 할 뿐 명확한 사업계획 등에 대한 답변은 없었음. 아울러 회사명의의 담보제공 부동산도 회사의 자본금이나 매출액 등을 고려할 때 그 규모에 걸맞지 않는 고가의 부동산이었음. 대출심사를 위해 사무실을 방문해 보니 전화 받는 직원 외에 다른 사람은 없었음.',
      CPT_WASH_ID: '00000000000000000043',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '위장법인을 담보로 거액의 대출을 받아 자금출처를 은닉할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)거액의 신규대출 후 합리적 이유 없이 단기간 내 현금 등으로 상환하는 거래 1',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '08',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '정○○는 A은행 B지점에 신원미상의 다수인과 함께 2억원의 현금을 소지하고 내점하여 최근 원거리지역인 C지점에서 정기예금을 담보로 한 일반자금 대출금의 상환을 요청하였음. 섭외차원에서 상환사유 등을 문의한 바, 별다른 답변은 하지 않고 다만, 여유자금이라고만 말하였음. 그리고 같이 내점한 다른 사람들과 비밀스런 이야기를 하는 등 상환자금과 관련 그 출처가 의심스러워 보고함.',
      CPT_WASH_ID: '00000000000000000044',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '원격지거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '거액의 예금을 담보로 한 대출금을 불법수익으로 단기간에 상환함으로써 자금출처를 은닉할 위험',
      SUSPI_TRTP_C: '02',
      TR_SCL_AM: '2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)거액의 신규대출 후 합리적 이유 없이 단기간 내 현금 등으로 상환하는 거래 2',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '08',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '최○○는 A은행 B지점에 내점하여 A은행 C지점에서 발행된 1천만원권 자기앞수표 30매로 대출금상환을 요청하였음. 동 대출금은 부동산을 담보로 제공하고 1주일 전에 A은행 B지점에서 받은 대출이었음. 섭외차원에서 대출금리 및 기간 등에 불만이 있어 대출금을 상환하는 지 등을 문의한 바, 고객은 명확한 답변을 회피하며 빨리 처리해 달라고만 하였음. 자기앞수표는 6개월 전에 발행된 것이었고 취득경위 등을 물어보니 제3자로부터 빌린 돈이라고만 할 뿐 명확한 답변을 회피하였음. 이에 수표발행 의뢰인을 확인해보니 20대 초반의 여자가 발행해 간 것이었고 대출 후 단기간에 대출금을 상환한 점 및 상환 자금의 출처가 의심되어 보고함',
      CPT_WASH_ID: '00000000000000000045',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '원격지거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '거액의 부동산을 담보로 한 대출금을 불법수익인 수표로 단기간에 상환하여 자금출처를 은닉할 위험',
      SUSPI_TRTP_C: '02',
      TR_SCL_AM: '3',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)거액의 대출을 경제적 합리성 없는 제3자가 대리인 자격으로 상환하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '08',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'A은행 B지점에 홍○○라는 사람이 내점하여 대리인이라고 하면서 자신의 보통예금계좌에서 2억원을 현금으로 인출하여 정○○명의의 대출금을 상환요청 하였음. 섭외차원에서 상환사유와 관계 등을 문의한 바, 고객은 명확한 답변을 회피하면서 다소 불쾌한 표정을 지었음. 통상 대출금 상환은 본인이 하거나 가족 등 가까운 사람이 상환하는 것이 일반적인데 반하여 다소 관계가 불명확한 제3자가 대출금을 상환하고, 그 자금도 대리인이라는 사람의 계좌에서 현금으로 출금하여 상환하였는 바, 당초의 대출금의 실제차주 및 상환 자금의 출처에 의심이 있고 직원의 질문에 명확한 답변도 하지 않아 의심스러워 보고함.',
      CPT_WASH_ID: '00000000000000000046',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '타인명의로 대출받은 후 불법수익을 대리인자격으로 상환하여 자금출처를 은닉할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '3',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)장기간 연체된 대출금을 합리적 이유 없이 상환하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '08',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '개인사업자 이○○는 A은행 B지점에 내점하여 장기간 연체중인 본인의 대출금 2억원을 현금으로 전액 상환하였음. 고객의 최근 사업형편으로는 비교적 거액인 연체대출금을 상환할 여유가없을 것으로 판단되어 상환자금 마련 등에 대하여 조심스럽게 문의한 바, 은행에서 상관할 바가 아니라고 하면서 몹시 불편한 심기를 나타냈음. 형편이 어려운 차주가 출처가 불분명한 거액의 현금으로 대출을 상환하고 직원의 질문에 대하여 명확한 답변을 회피한 바, 의심스러워 보고함.',
      CPT_WASH_ID: '00000000000000000047',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '연체대금이 거액이며 일시에 현금으로 상환함으로써 자금출처를 은닉할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)미성년자 명의의 채무인수거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '08',
      CUS_CHR_C_NM: '미성년자 / 고령자',
      CPT_WASH_CNTN: 'A은행 B지점에 평소 거래가 없던 갑이 방문하여 시가 10억원 상당의 아파트를 담보로 6억원의 대출을 받았음. 며칠 후 갑이 다시 방문하여 미성년 자녀 명의로의 채무인수를 요청하였음. \r\n여신담당직원은 동 아파트 등기부등본을 발급받아 자녀명의로의 소유권 변경 및 전세권 설정 사실을 확인하고, 채무양도․양수 절차를 수행하였음. 이 과정에서 자녀(채무인수인)의 채무상환 능력이 의심되어 자녀계좌의 거래내역을 확인한 바, 대출 이후 여러 차례에 걸쳐 부친명의로 자녀계좌에 일정금액이 현금으로 입금된 것이 의심되어 보고함.',
      CPT_WASH_ID: '00000000000000000048',
      CUS_CHR_C: '03',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '부동산 담보대출 후 단기간 내 재무자를 미성년자인 자녀 명의로 변경하여 조세탈루할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '6',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)거래의 목적이 의심되는 법인보유 상장 유가증권 담보대출거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '기존 거래처인 A법인 대표이사 갑은 동 법인이 투자유가증권으로 보유하고 있는 코스닥 상장법인 주식을 담보로 3억원의 운전자금 대출을 신청하였음. 담당직원은 A법인의 재무상태와 기존 거래관계 등을 고려하여 대출을 실행한 후, 갑에게 대출금이 A법인계좌로 입금되었음을 전화로 안내하였음.\r\n갑은 대출금 입금 당일 3회에 걸쳐 현금으로 출금한 후 이를 타인 명의로 (주)△△식품 법인계좌로 송금을 요청하였고, 송금사유를 묻자 단순히 물품대금이라고만 하며 답변을 회피하였음. A법인은 소형선반을 제조하는 기업으로 (주)△△식품과의 업종 및 거래 관련성이 적은 것으로 판단되어 의심되는 거래로 보고함.',
      CPT_WASH_ID: '00000000000000000049',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '법인 소유의 투자유가증권을 담보로 대출받아 현금으로 출금한 뒤, 타인 명의로 제3자에게 송금하는 거래를 이용해 개인의 비자금을 형성할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: '3',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)대표이사 및 최대주주의 변경이 빈번한 법인의 합리적 이유없는 담보대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '기존 거래처인 B법인 대표이사 갑이 동 법인 소유 부동산을 담보로 5억원의 운전자금 대출을 신청하였음. B법인은 코스닥 상장법인으로 최근 대주주가 자주 변경되고 매출이 감소하는 등 경영상 어려움을 겪고 있었음.\r\n불과 한달 전에 대표이사로 취임한 갑은 회사의 업무를 명확히 알지 못하였고 담보물로 제공하는 부동산에 대해서도 자세한 정보를 모르는 등 법인 자산의 유출을 통해 비정상적 거래를 하는 것으로 의심되어 보고함.',
      CPT_WASH_ID: '00000000000000000050',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '경영이 어려운 상장법인을 인수한 뒤, 대출금으로 개인의 비자금 형성 및 타 법인 인수자금으로 유용될 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: '5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '13',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)법인의 담보를 이용한 특수관계인 명의 대출금 상환거래',
      BZC_DSC_NM: '무역업',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '서울시 서초구 소재 (주)△△물산의 과점주주인 갑이 거래은행인 A은행 B지점에 방문하여 동 법인의 예금을 담보로 4억원의 가계자금 대출을 신청하였음. 대출금은 입금 당일 현금으로 인출되어 대표이사 아들인 주주 을의 계좌로 송금되었음.\r\n며칠후 (주)△△물산은 자본금 증자를 위해 을의 명의로 증자를 신청하였으며, 증자 대금은 갑이 송금한 자금이었음. 자본금 증자가 완료된 후 회사의 증자 대금은 수표로 인출되어, 며칠 후 갑의 대출금 상환에 사용되었음. 법인 소유 예금을 특수관계인에게 담보로 제공하고 그 대출금으로 증자 대금을 납입한 후 인출하여 동 대출금을 상환하는 것으로 판단되어 의심되는 거래로 보고함',
      CPT_WASH_ID: '00000000000000000051',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '법인의 담보를 이용하여 특수관계인이 대출한 뒤,  특수관계인 또는 제3자에게 자금이 제공되거나 주금가장납입, 변칙상속 등이 발생할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: '4',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적 이유 없이 계약체결 후 단기간 내에 해약하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '01',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '[보고내용]\r\n특별한 직업이 없는 가정주부가 고액의 일시납 계약을 체결한 후 6개월 되는 시점에 특별한 이유 없이 해약을 요청하면서 해약환급금을 현금으로 지급받기를 원했음. 해약환급금이 원금의 90% 정도 밖에 되지 않아 계속 유지를 권유 하였으나 갑자기 돈이 필요하다며 극구 해약하기를 원하여 현금수령은 불편할 것이라며 이용편의를 위하여 해약환급금을 통장수령 또는 수표로 수령할 것을 권유하였으나, 합리적 이유 없이 현금으로만 지급해 달라고 재차 이야기했음',
      CPT_WASH_ID: '00000000000000000052',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '현금에 집착하는 거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 고액 보험청약 후 단기간 내 해약하므로써 불법자금을 금융기관에 투입한 후 단기간 내에 자금을 회수할 위험',
      SUSPI_TRTP_C: '05',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 수회에 걸쳐 집중적으로 보험 계약대출을 받은 후 곧바로 해약하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n최근 어떤 고객이 고객창구를 방문하여 일정금액 이상 금액의 보험계약 대출을 현금으로 수회에 걸쳐 받아가는 고객이 있어 계약사항을 살펴보니, 계약을 한지 1년이 채 되지 않았고, 며칠 후 다시 찾아와서 얼마 되지 않은 그 계약을 해약하며 나머지 해약환급금을 찾아가려 함에 따라 해약사유를 물어보니 그런걸 왜 물어보냐며 거부감을 나타내고 일전에 한 보험계약 대출이 부담되어 해약한다고 하였으며 보험계약 대출과 해약환급금을 합한 금액이 원금에도 미치지 않았음',
      CPT_WASH_ID: '00000000000000000053',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 정상적인 거래인 것처럼 소액의 대출을 분할하여 받음으로써 보험회사에 투입된 불법자금을 합법화할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 계약자의 직업, 재산상태 등에 비추어 특별한 사유 없이 고액의 보험계약을 체결하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '01',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '[보고내용]\r\n고액의 보험계약을 체결하는 과정에서 미래의 불확실한 위험에 대비한다는 보험의 가입 목적에는 별로 관심이 없고, 보험특성상 계약자의 직업 등에 대해 문의하였으나 고지한 직업이 상식적으로 고액소득자로 보기에는 어려운 측면이 있고 특별한 직업도 없는 것으로 보였음. 특별한 소득이 없음에도 어떻게 고액 계약이 가능한지 물어보자 보험사에서 그런 것까지 알아야 하냐는 등 더 이상 대답하는 것을 기피하였음',
      CPT_WASH_ID: '00000000000000000054',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '무관업종 또는 의심스러운 재산에 대한 보험청약 거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 고액의 불법자금을 금융기관에 유입시킬 위험',
      SUSPI_TRTP_C: '15',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 보험금 수령 후 계약자, 피보험자가 아닌 제3자에게 거액을 송금  의뢰하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n계약자나 수익자가 보험금을 직접 수령하지 않고 제3자의 통장으로 송금이체를 요구하여 계약자나 수익자 이외 제3자에게는 송금이 불가함을 안내하였으나 막무가내로 제3자 송금을 요구하였으며, 직접 송금이 불가하면 일단 본인이 수령한 것으로 한 후 재 송금한 것처럼 해달라는 등 정상적인 절차를 위배하여 처리해 줄 것을 요구하였음',
      CPT_WASH_ID: '00000000000000000055',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '다중거래의 동시요청',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 계약에 대한 제지급금 등을 정당한 권리자가 직접 수령하지 않고 제3자에게 송금을 의뢰하거나 형식적으로 계약자 본인에게 지급처리를 한 후에 제3자에게 송금을 부탁하는 경우 명목상 계약자와 실제 계약자가 다를 위험',
      SUSPI_TRTP_C: '11',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '07',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적 사유 없이 보험계약 체결 후 비교적 단기간 내에 고액의 보험료를 선납하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n고객이 특별한 사유 없이 본인 및 가족 등의 명의로 다수의 보험계약을 체결하고 수개월 내에 남은 기간의 보험료 전액을 선납하였음. 다수의 보험계약 자체도 적은 액수가 아니었으며 남은 기간의 보험료 총액은 상당한 고액이었음. 최초 계약 시 선납을 하였으면 보험료 할인 혜택 등이 있었음을 설명하며 이유를 물어보자 알 필요 없다며 구체적인 답변을 회피하였음',
      CPT_WASH_ID: '00000000000000000056',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '분할거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 단기간 내 다수의 고액의 보험계약을 체결하고, 일정기간이 경과한 뒤, 남은 기간의 보험료 전액을 선납하므로써 의심을 회피할 위험',
      SUSPI_TRTP_C: '04',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 고액의 보험료가 일정한 관계가 없는 타인의 통장에서 지속적으로 납입되는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '03',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n고객이 본인 명의로 고액의 보험계약을 체결하였으며, 자동이체를통하여 제3자의 통장에서 보험료가 이체되었음. 통장 예금주에게 사실확인을 하는 과정에서 예금주는 보험계약 체결과 관련하여 질문하자 내용을 자세히 모르는 듯한 말을 하며 계약자와의 관계를 물어도 대답을 거부하였음',
      CPT_WASH_ID: '00000000000000000057',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '무관업종 또는 의심스러운 재산에 대한 보험청약 거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 계약자 명의와 다른 제3자의 명의의 계좌에서 고액의 보험금을 납입함으로써 제3자의 불법자금이 세탁될 위험',
      SUSPI_TRTP_C: '15',
      TR_SCL_AM: null,
      PYM_CHAN_C: '1',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 대표이사 등이 법인 명의 계약에 대하여 현금 등으로 중도인출',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n실질적으로 주주가 대표이사 1인 또는 그 가족이나 친인척으로 구성된 비상장법인이 대표이사를 피보험자로 한 고액 일시납 보험계약을 체결한 후, 단기간 내에 수차례 중도인출을 하면서 법인계좌가 아닌 대표이사 또는 위임받은 대리인에게 현금 또는 수표로 지급해 줄 것을 요청하였음',
      CPT_WASH_ID: '00000000000000000058',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 가족 등으로 주주가 형성된 비상장법인의 보험계약 등을 내세워 불법수익을 세탁할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 법인 명의 계약체결 후 법인대표로 계약자를 변경하고 해지 후 현금 수령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '01',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n법인고객이 특별한 사유 없이 당해 법인 명의로 거액의 장기 보험계약을 체결하고 단기간에 남은 기간의 보험료 전액을 선납하였음. 보험료 납입금액이 적은 액수가 아니었으며 남은 기간의 보험료 총액은 상당한 거액이었음. 몇 개월 후 계약자를 법인대표로 변경하였고, 법인대표는 며칠이 지나지 않아 보험계약을 해지한 후 미경과 보험료를 수령하였음',
      CPT_WASH_ID: '00000000000000000059',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '무관업종 또는 의심스러운 재산에 대한 보험청약 거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 법인명의의 거액의 보험에 가입한 뒤, 계약자를 법인에서 대표로 바꿈으로써 보험을 이용한 자금세탁이 이뤄질 위험',
      SUSPI_TRTP_C: '15',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 보험을 이용한 탈세 의심 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '미성년자 / 고령자',
      CPT_WASH_CNTN: '[보고내용]\r\n고령의 계약자가 각각 수 억원씩 여러 건의 변액 유니버셜보험에 가입한 후, 매월 특정일에 자녀들이 중도인출서비스를 이용하여 대리수령을 하면서 현금으로 지급해 줄 것을 요청하였음. 이에 보험회사가 고객의 편의 및 회사의 보험금 지급정책상 통장을 통하여 수령할 것을 권유하였음에도, 특별한 이유없이 현금으로 지급해 줄 것을 요구하였음',
      CPT_WASH_ID: '00000000000000000060',
      CUS_CHR_C: '03',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '현금에 집착하는 거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 거액의 보험에 가입한 뒤, 자녀들의 대리중도인출을 통해 재산 증여세를 탈루할 위험',
      SUSPI_TRTP_C: '05',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 계약체결 후 단기간 내에 고액의 보험계약대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '01',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n개인사업자라는 고객이 고액의 일시납 계약을 체결한 후 1개월쯤되어서 고객창구를 방문하여 보험계약 대출을 한도만큼 현금으로 지급해 달라고 요청하였음. 계약한지 얼마 되지도 않았는데 왜 그 많은돈이 현금으로 필요하냐며 물어보니, 자신에 대해 관심을 갖는 것에대한 거부감을 나타내면서 사업상 갑자기 필요하게 되었다는 말만 하였음',
      CPT_WASH_ID: '00000000000000000061',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 고액의 보험에 가입하고 보험계약 대출을 받아 불법자금을 합법적으로 회수할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 보험계약대출과 상환을 반복하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '06',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n작은 회사에 근무한다는 고객이 고객창구에 방문하여 현금으로 보험계약 대출을 받은 며칠 후 바로 현금으로 상환하고, 또 며칠 후 보험계약 대출을 받은 후 바로 상환하고 하기를 반복하였음. 고객창구를 방문하면 불편할테니 사이버나 전화를 이용한 통장 송금거래를 권유하였으나, 다음에 또 방문하여 대출과 상환을 반복하였다. 자주 돈 쓸 일이 필요한가 보다며 말했더니, 거부감을 나타냈음',
      CPT_WASH_ID: '00000000000000000062',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '빈번한 입출금(입출고)',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 단기간 내에 대출과 상환을 현금으로 반복하면서 보험상품을 자금세탁의 용도로 사용할 위험',
      SUSPI_TRTP_C: '12',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 대출금을 단기간 내에 상환하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '06',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n직장에 다닌다는 고객이 집을 사는데 돈이 필요하다며 대출을 요청하였음. 최초 대출계약을 할 당시에는 대출기간을 30년으로 하여 대출을 실행하였는데, 대출일로부터 한달이 지나지 않아 거액의 현금으로 007가방에 넣어서 상환하러 왔음. "갑자기 어떻게 돈이 마련되었냐"며 물어보면서" 통장에 넣어두고 전화 한통만 주시면 상환처리가 가능한 편리한 방법이있는데, 현금을 직접 가지고 방문하였냐"고 물어보았더니, "누구로부터 현금을 직접 받아서 가지고 오게 되었다"고 말하며 자세한 얘기는 하지 않았으며 고객의 재산상태에 비추어 큰 자산의 처분 없이는 그 만한 현금을 쉽게 구하기 어려울 것으로 보였음',
      CPT_WASH_ID: '00000000000000000063',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 고액의 대출을 받고 단기간 내에 현금으로 상환하는 방법으로 불법수익을 세탁할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 대출금리 등 타 금융기관의 대출이 유리함에도 합리적 이유없이 특정 금융기관과 대출을 고집하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n당해 금융회사의 기준으로는 대출금리나 대출기간 등의 조건이 타금융기관 보다 현저히 떨어짐에도 불구하고 그러한 대출 조건에 전혀 관심이 없이 막연하게 당해 금융회사의 대출을 고집하였음. 또는 통상 1년 기간의 대출임에도 불구하고 1~2개월의 단기대출을 요구하거나 문의를 하였음',
      CPT_WASH_ID: '00000000000000000064',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 불합리한 계약조건을 무시하고 계약을 강행하여 자금을 세탁할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 보험을 이용한 탈세 의심 거래 2',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '08',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n대출채무자인 자녀가 담보대출 상환을 위해 1개월 동안 3회에 걸쳐 창구를 방문하였음. 매번 거액의 현금으로 상환(첫 번째 방문시 3,500만원, 2일 후인 두 번째 방문시 2,600만원, 10일 후인 세 번째 방문시 3,900만원을 각각 상환)하였고, 처음 업무처리를 담당했던 창구직원에게 두 번째, 세 번째 업무처리를 요청하였고, 매 번 동 직원에게 거래에 대한 비밀을 지켜줄 것을 요구하였음',
      CPT_WASH_ID: '00000000000000000065',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 거액의 대출금을 거액으로 상환하므로써 불법수익을 세탁할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)상품단가 조작을 통해 부풀려진 수출매출채권의 할인',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '과거부터 대출거래를 해 오던 가전업체인 ㈜○○○로서 대출기한이 도래하여 대출갱신을 요청함. 은행에서는 동 대출 절차상 동 수출업체에 대해 현장 조사를 한 후 미국에 있는 해외의 바이어에 대한 현장 조사를 하고자 하였으나, 동 수출업체는 미국이 아닌 다른 나라를 방문할 것을 권고하여 금융회사에서는 거래규모가 가장 큰 미국의 바이어를 방문하겠다고 하니, 동 수출업체는 매우 불쾌해 하며 기존의 대출을 모두 상환하고 거래를 중단함. 동 업체의 거래중단 과정이 미심쩍어 과거의 수출서류 등에 대해 조사한 결과, 동 수출업체는 수출물품의 단가가 지나치게 과다 계상하여 매출채권을 할인하였음이 발견되어, 의심거래로 보고함',
      CPT_WASH_ID: '00000000000000000118',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '대출 갱신에 대하여 현장조사를 거부하고, 기존 대출을 모두 상환하고 거래를 중단하는 행위',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험)합리적 이유없이 계약체결 후 단기간 내에 해약하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '01',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '거래자는 저축보험의 계약자로 매월 보험료를 납입하는 것 외에 선납 및 추가납입을 통하여 고액의 보험료를 납입하였고, 고액의 보험료를 선납한 다음날 선납 금액과 동일한 금액을 중도인출 하였음. 수개월 후 계약을 해지하였고, 계약해지 시 거래자는 해지환급금을 거래자명의의 여러 은행 계좌로 분할하여 송금하여 줄 것을 요구',
      CPT_WASH_ID: '00000000000000000119',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '합리적인 사유 없이 고액 보험료를 선납 및 추가납입 후, 단기간 내 중도 인출하였고, 이 후 얼마 지나지 않아 계약을 해지함. 해지환급금을 여러 개의 계좌로 분할하여 송금하여 줄 것을 요구',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 법인 명의 계약체결 후 법인대표로 계약자를 변경하고 해지 후 현금 수령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '법인 명의의 계약을 회사 임직원으로 계약자를 변경하였으나, 자동이체 예금주는 변경하지 않아 법인 통장에서 고액의 보험료가 계속 이체되고 있음. 자동이체 계좌주를 변경하지 않는 이유를 문의하였으나 회사가 계속 납부해주기로 했다는 말만 하며 정확한 답변을 하지 않음.',
      CPT_WASH_ID: '00000000000000000120',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '법인계약자 변경 후 자동이체 예금주 미변경',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '1',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 보험을 이용한 탈세 의심 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '고액의 보험 가입 후, 일정 기간이 지난 후 자녀나 가족명의로 계약자 및 수익자를 변경한 후 계약을 해지하거나 만기 환급금을 수령하는 행위. 해당 계약의 만기 및 해지 환급금은 변경된 계약자인 자녀나 가족 명의의 계좌로 이체요구 함.',
      CPT_WASH_ID: '00000000000000000121',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고액의 보험 가입 후 자녀나 가족명의로 계약자, 수익자를 변경하여 만기 환급금을 받거나 해지하여 환급금을 수령하는 행위',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '04',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '���심거래 참고유형 (2015)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: 'TM',
      CPT_WASH_TI_NM: '(보험)여러 기업을 거느린 오너가 다수의 계열사들로 하여금 자신을 피보험자로 하는 고액의 저축성 보험을 체결하게 하는 행위',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '다수의 기업을 거느린 기업집단의 대주주 A는 자신의 영향력 아래에 있는 그룹 계열사에게 특정 보험대리점의 특정 설계사를 통해 피보험자를 자신으로 하는 고액의 연금계약을 다수 체결하게 함. 계열사들은 매출 및 순익 규모별로 단기간內 상당 금액의 연금계약을 집중 가입함.\r\n계약 체결 과정을 확인한 결과 해당 설계사와 대주주 A와는 특별한 연고나 이해관계가 없어 고액의 수수료가 발생하는 다수의 고액 연금 계약을 한 명의 설계사에게 밀어줄 이유가 없는 상태임. 따라서, 보험 대리점을 이용하여 우회적으로 불법자금을 마련하기 위한 방법으로 판단됨.',
      CPT_WASH_ID: '00000000000000000122',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '분할거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고액의 생명보험계약 체결시 설계사에게 상당한 모집수수료가 발생하는 점을 이용, 계열사의 정상적인 자산운용을 가장하여 저축성 보험계약을 체결한 뒤, 발생된 모집수수료의 우회적인 환급을 통해 비자금조성, 조세포탈 등을 꾀하는 자금세탁 유형',
      SUSPI_TRTP_C: '04',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '2',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 보험계약대출과 상환을 반복하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '대리점 명의로 계약한 보험을 합리적 이유 없이 보험계약대출 실행 후 보험료 납입을 반복하는 거래로, 대리점 설계사 및 직원을 피보험자로 한 계약 체결 후 일정기간이 지난 후 보험계약대출을 실행하고 보험료 납입을 반복하였음. 여러 명의 계약자 및 대리점 직원이 고객센터 방문 후 차례대로 약관대출 및 중도인출을 받고 다시 보험료 납입을 계속하여 사유를 묻자 보험계약대출이자를 회사도 받지 않느냐는 등 합리적인 답변을 하지 못하였음.',
      CPT_WASH_ID: '00000000000000000123',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '합리적인 이유없이 보험계약대출을 실행 후 보험료 납입을 반복하는 거래',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-상호저축은행)(여신)취득경위에 의심이 가는 타인명의 재산을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '평소 거래가 없던 고객이 내점하여 제3자 부동산을 담보로 대출받기를 원하여 대출상담을 하면서 제3자로 담보를 제공하는 자와 신청 고객과는 아무런 관계없는 타인처럼 보였으며, 담보로 제공하는 부동산의 소유가 빈번하게 변경된 사실을 확인하였음. 대출시 고액을 반드시 현금으로 인출할 수 있도록 요구하였으며, 저축은행의 대출취급규정에 따른 고금리의 대출이율과 취급수수료를 설명하였으나 거부감 없이 받아들이며, 대출이 가능하고 현금으로 인출이 가능하다면 당장이라도 대출을 받고 싶다고 하여, 자금의 용도 및 담보제공자와 대출신청자의 관계 등을 물었으나 구체적인 답변을 회피하였음.',
      CPT_WASH_ID: '00000000000000000124',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '현금에 집착하는 거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '취득경위에 의심이 가는 타인명의 재산을 담보로 하는 대출 거래',
      SUSPI_TRTP_C: '05',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '01',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-상호저축은행)(여신)사업자등록증의 위∙변조를 통한 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '법인이 아닌 개인고객이 금융기관의 개인 여신한도 이상의 대출을 받기 위하여 사업자등록증을 위∙변조하여 개인 여신한도를 초과한 거액여신을 받은 후 자금 세탁하여 불법한 용도로 사용하였음.',
      CPT_WASH_ID: '00000000000000000125',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '개인의 여신한도 제한으로 인해 타인의 사업자등록증을 위∙변조하여 대출을 신청하고 대출금을 불법용도로 사용한 거래',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-상호저축은행)(여신)빈번한 예금 담보대출을 이용하는 금융거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '06',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '정기예금(장기간 계속거래 중)을 담보로 수시로 대출(통상 5천만원 ~ 1억원 정도)받아 제3자(개인 또는 법인) 앞으로 송금하거나 지급하고, 단기간(1개월 이내)에 상환하는 거래가 발생하였음.',
      CPT_WASH_ID: '00000000000000000126',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '예금을 담보로 대출받아 제3자에게 송금하고, 단시일에 상환하는 거래',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-상호저축은행)(여신)합리적 이유없이 장기간 연체된 대출금을 갑자기 상환하는 경우',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '06',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '자금사정이 어렵다며 거액의 금고 대출금을 장기간 연체하고 있던 고객이 갑자기 연체대출금을 일시에 상환하였음. 고객의 최근 형편으로 보아 연체대출금을 상환할 여유가 없을 것으로 판단되어, 상환자금의 원천에 대하여 물었는데 고객은 자세한 답변을 하지 않았음.',
      CPT_WASH_ID: '00000000000000000127',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '거액의 금고 대출금을 장기간 연체하고 있던 고객이 갑자기 연체 대출금을 일시에 상환',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-새마을금고)(여신)취득경위에 의심이 있는 거액을 정기예금하고 범위 내 대출을 요구하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '사업체를 운영하고 있는 대표자가 본인과 회사 명의로 장기간 거래를 하고 있었음. 대표자는 거래처로 보이는 업체로부터 송금받은 거액의 자금을 인출하여 회사 명의로 1년만기 정기예금에 가입하였고, 수일 후 이사회 회의록, 위임장 등 서류를 구비하여 범위 내 대출을 신청하였음. 대출금은 회사의 납품업자라고 지칭하는 개인에게 송금하였고, 이자회수를 위해 자동이체를 권유하였으나 이를 거절하며 회사의 다른 자금으로 납부하겠다고 하였음. 이후 거래는 계속되었으며, 회사의 경리직원이라고 소개한 사람이 인터넷거래를 통하여 회사 명의로 이자를 납입하였음.',
      CPT_WASH_ID: '00000000000000000128',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '법인명의로 정기예금을 하고 범위 내 대출을 받아 사용하는 거래',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: null,
      PYM_CHAN_C: '1',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 실효된 계약을 타 지역 설계사에게 부활 요청하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '04',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[보고내용]\r\n고객은 평소 개인적으로 친분이 있던 설계사에게 고액의 보험계약을 체결하였으며 충실히 계약을 유지해 왔으나 고객의 사정 악화를 이유로 보험계약을 유지할 수 없다는 통보가 왔고 얼마 후 보험계약은 실효가 되었음. 경제적 어려움이 있더라도 가능하면 계약을 유지하고, 안되면 환급금을 수령해 갈 것을 안내하였으나 아무런 연락이 없다가 갑자기 타 지역 설계사로부터 부활을 요청받았다는 내용을 통보받았음. 최초 담당 설계사가 고객에게 연락하여 사유를 물어 보았으나 "귀찮게 하기 싫어서"라며 대답을 회피 하려고만 하였음',
      CPT_WASH_ID: '00000000000000000105',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '원격지거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 보험 실효 후 미납된 납입금을 납부하면 부활하는 보험제도를 이용하여 자금을 세탁할 위험',
      SUSPI_TRTP_C: '02',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-새마을금고)(여신)타인명의 재산을 담보로 거액의 대출을 받는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '업무구역 내에서 거래를 하고 있는 고객이 친구라는 사람과 방문하여 거액의 대출을 신청하였음. 고객은 사업을 하려고 하는데 급한 돈이 필요하여 친구의 부동산을 담보로 제공하겠다고 하면서 등기부 등본 및 기타 설정에 필요한 서류를 제출하였으나 고객은 상환조건, 대출금리, 등기비용 등에 대해서는 별 관심이 없었으며, 하루빨리 대출을 해 달라고 거듭 부탁을 하였음. 상담 시 대화 내용으로 볼 때 둘 사이에는 그다지 친분관계는 없어 보였으며, 담보부동산의 구입일자가 얼마되지 않았고 실행된 대출금은 차주의 온라인통장으로 지급되었으나 친구라는 사람이 통장을 사용하는 것으로 파악되었음.',
      CPT_WASH_ID: '00000000000000000129',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '타인명의 부동산을 담보로 대출을 신청하면서 대출조건에는 관심이 없고 대출만 요구하는 거래',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-새마을금고)(여신)자금출처가 명확치 않은 거액의 현금을 대출금 상환에 이용한 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '06',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '평소 거래를 많이 하고 있는 고객이 아들로 보이는 사람과 함께 객장을 방문하여 대출상담을 하였음. 아들이 결혼하여 새집을 구입하려고 대출을 받을 계획이라 하면서 관련서류를 제출하였음. 아들은 소유권 이전과 함께 설정등기를 마쳤으며 곧바로 대출이 이루어졌음. 이후 아들은 몇번에 걸쳐 이자를 보내 왔으나 갑자기 부모와 함께 거액의 현금을 지참하고 방문하여 대출금을 상환하려 하여 자금출처를 물었으나 명확한 답변이 없었으며, 나중에 안 사실이지만 부모의 자금으로 상환되었음이 확인되었음.',
      CPT_WASH_ID: '00000000000000000130',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '자금출처가 명확치 않은 거액의 현금을 대출금 상환에 이용한 거래',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-새마을금고)(여신)고액의 신규대출 거래를 신청하면서 회원가입신청서, 신용조사서 등 각종 기재사항의 기록을 회피하는 경우',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '평소 거래가 없던 고객이 지방에 소재하는 부동산을 담보로 부동산 구입자금 대출을 신청하였음. 창구에서 업무안내 시 귀찮아 하는듯한 인상이었으며, 회원가입신청서, 신용조사서 등 서류의 기재사항에 대하여 기본사항 외에는 기재를 거부하였으며, 대출금리나 상환조건 등에는 관심이 없고 거래사항에 대하여 가족이 모르게 해달라는 부탁과 함께 빠른 대출을 원하였음.',
      CPT_WASH_ID: '00000000000000000131',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '현금에 집착하는 거래',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '신규고객이 거액의 부동산 구입자금 대출을 신청하면서 이유없이 각종 기재사항의 기록을 거부하는 거래',
      SUSPI_TRTP_C: '05',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-신용협동조합)(여신)담보가 있는 일반대출이 연체가 되어 독촉을 하자 채무자와 이해관계가 있는 자가 대위변제를 하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '채무자를 대위해서 변제할 수 있는 자는 이해관계자로 연대 채무자, 보증인, 담보제공자, 후순위 담보권자, 담보물의 제3취득자 등 변제할 정당한 이익이 있는 자를 말하며, 단순히 부모, 형제 등 친족관계만으로는 이해관계자에 해당되지 않음. 그러나 동 연체대출에 대하여 이해관계가 없는 친족이라는 자가 대위변제 신청을 요청하여 대위변제 사유를 파악하여 승인여부를 결정키위해 사유를 문의하였으나, 별 다른 이유가 없는 것으로 파악되어 신청을 반려시켰음.',
      CPT_WASH_ID: '00000000000000000132',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '대출에 이해관계 없는 제3자가 채무자를 대위하여 변제하는 거래',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-신용협동조합)(여신)소규모 점포에서 합리적인 이유 없이 여신 거래금액의 규모가 커지는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '조합과 신용카드 매출채권을 담보로 일정금액을 한도로 대출할 수 있는 한도 대출약정을 맺은 조합원의 소규모 점포에서 갑자기 거래 금액의 규모가 커지면서 대출금액이 증가하여 조합에서는 대출금 증가 사유를 파악하고자 점포를 방문하여 점포의 영업상태를 확인하였으나 평소와 큰 차이가 없어 조합원에게 매출금액 확대사유를 확인하였으나 납득할 만한 사유를 설명하지 못하였음.',
      CPT_WASH_ID: '00000000000000000133',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '신용카드 매출채권 담보대출 약정을 맺은 소규모 점포에서 대출 금액이 갑자기 증가하는 거래',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'KoFIU사례_연차보고서\r\n(2012)\r\nP.84',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '04',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '프랜차이즈 업체의 조세 포탈 사례',
      BZC_DSC_NM: '귀금속 등 현금집중사업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '혐의자는 프랜차이즈사 대표자로 10개월 정도 거래가 없다가 은행 지점을 방문하여 현금 약 11억 원과 수표 약 6억 원을 입금하였다. 그런데 입금된 수표는 발행 연도가 1년~3년 이상 경과한 구권으로, 다량의 소액권 수표와 고액의 현금이 묶음처리 되어 있지 않는 등 정상적인 거래로 볼수 없는 점이 많아 의심거래로 보고하였다.\r\n\r\n[심사분석 내용]\r\n분석결과 혐의자는 프랜차이즈 업체를 운영하는 자로서 가맹업체로부터 가맹비, 시설비 등으로 받은 수표 및 현금 등을 계좌에 입금하지 않고 상당기간 보관하다가 금융투자회사나 증권회사에 입금한 것으로 확인되었다. \r\n\r\n[수사/조사 결과]\r\n조사결과 혐의자는 수년이 경과한 억대의 십만원권 자기앞수표 뭉치를 입금하고 수십억원 대의 현금을 대표 개인계좌로 입금하는 수법으로 4년간 총 250억원 상당의 매출을 누락하였다. 결국 133억원의 세금을 추징당하였으며, 조세포탈 혐의로 검찰에 고발조치되었다.',
      CPT_WASH_ID: '00000000000000000134',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 프랜차이즈사 대표가 가맹업체로부터 받은 현금 및 수표 등을 수년간 보관해 오다가 자신의 개인계좌에 입금하는 등 회사매출을 누락하는 수법으로 관련 조세를 포탈할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '250',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '1',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)취득경위가 의심되는 부동산을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '평소 거래관계가 없고 직업도 불분명한 해외교포 갑이 내점하여 국내에서 취득한 고가의 부동산을 담보로 대출을 요청하였으며, 갑은 대출금리와 상환방법 등 대출조건에는 별 관심이 없었고, 자금의 용도 및 현지사업내용 등을 문의하였으나 구체적인 답변을 회피하였음. 등기부등본을 확인해 보니 수 일전에 소유권을 취득한 것으로 갑의 국내 거소는 영업점으로부터 원거리에 위치한 거래',
      CPT_WASH_ID: '00000000000000000038',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '취득경위가 의심되는 고가의 부동산을 담보로 대출을 받아 불법수익을 합법화할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'KoFIU사례_연차보고서 (2012) P.84',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: 'KoFIU사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '프랜차이즈 업체의 조세 포탈 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 384억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000341',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '250억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '2',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '2'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '부당담보대출',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '○○은행 △△지점 과장대리 ○○○는 어머니 명의를 이용하여 대출약정서 없이 농지담보조건으로 종합통장대출 29백만원을 전산등록한 후 대출취급하여 사용하였으며, 2개월 후 대출약정한도를 14백만원 증액하는 방법으로 총 43백만원을 횡령',
      CPT_WASH_ID: '00000000000000000023',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '창구전결권을 이용하여 직원이 부당담보대을 받아 대출금을 횡령할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: '.4',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: null,
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 보험료 영수증 및 보험증권을 이용한 횡령',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '영업소장 ○○○는 계약자에게 1년 후에 세후 연 12%의 이자를 지급하기로 약속하고 20백만원을 받아 횡령한 후 보험료영수증 및 보험증권을 위조하여 교부하였으며, 퇴사한 후에도 동 계약자에게 세후 연 12%의 이자를 지급하기로 약속하고 두 차례에 걸쳐 13백만원을 받아 동일한 수법으로 횡령',
      CPT_WASH_ID: '00000000000000000024',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위 보험료 영수증 및 보험증권을 이용하여 고객의 보험금을 횡령할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.1',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 보험료 영수증 및 보험증권을 이용한 횡령',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '01',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '설계사 ○○○는 계약자 3명으로부터 70백만원을 일시납으로 수령한 후 회사에는 단기 저축성 월납 계약으로 성립시키고, 허위분실 신고하는 방법으로 확보한 영수증 및 보험증권을 변조하여 계약자에게 건네준 뒤, 매월 보험료를 입금하는 수법으로 합계 7백만원을 입금하고 차액 63백만원은 횡령',
      CPT_WASH_ID: '00000000000000000025',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고객이 가입한 상품과 상이한 상품을 등록하고 차액을 횡령할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.7',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사의 개인 수금 보험료 유용',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '설계사 ○○○는 10명의 계약자로부터 보험료를 일일수금하는 방법으로 보험료 8백만원을 회사에 입금하지 아니하고 유용하다가 월말 또는 실효 직전 입금',
      CPT_WASH_ID: '00000000000000000026',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '설계사가 직접 수금한 보험료를 입금시키지 않고 개인적이로 유용할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.06',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사의 개인 수금 보험료 유용',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '설계사 ○○○는 초등학교 동창인 계약자 ○○○에게 사내 전산망의 에러로 보험료 납입이 전산 처리되지 않는다고 한 후 보험료를 직접 납입할 것을 요구하고 방문 수금하여 150만원을 횡령',
      CPT_WASH_ID: '00000000000000000027',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '설계사가 직접 수금한 보험료를 입금시키지 않고 개인적이로 유용, 횡령할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.02',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사의 개인 수금 보험료 유용',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '설계사 ○○○는 계약자로부터 보험료를 개인 통장으로 받아서 입금시키던 중 자금사정이 악화되자 2백만원의 보험료를 횡령하고, 횡령 후 회사의 해지예고 통보안내문이 계약자에게 도달되지 않도록 계약자의 주소를 변경하여 횡령사실 은폐',
      CPT_WASH_ID: '00000000000000000028',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '설계사가 직접 수금한 보험료를 입금시키지 않고 개인적이로 유용, 횡령할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.02',
      PYM_CHAN_C: '1',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '14',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 고객 인적사항의 도용을 통한 고객 보험료 횡령',
      BZC_DSC_NM: '비은행 금융기관(은행 이외 제2금융권)',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '영업소장 ○○○는 고객의 신분증을 위조하여 ○○은행 등 2개 은행에서 공인인증서를 발급받은 후, 홈페이지의 사이버창구를 접속하여 해당고객 계약에서 보험계약대출 10백만원을 취급하여 횡령',
      CPT_WASH_ID: '00000000000000000029',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험설계사가 고객 인적사항을 도용하여 고객의 보험료를 횡령할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '.1',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '14',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 고객 인적사항의 도용을 통한 고객 보험료 횡령',
      BZC_DSC_NM: '비은행 금융기관(은행 이외 제2금융권)',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '○○보험회사 수원/경기일대 지점에서 전문사기단이 부동산등기부등본에서 확인한 성명 및 주민등록번호를 이용 ARS로 보험계약사항을 확인한 후, 운전면허증을 위조하여 계약자로 행세하며 보험계약대출금 9백만원을 수령하여 횡령',
      CPT_WASH_ID: '00000000000000000030',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '타인이 고객 인적사항을 도용하여 고객의 보험료를 횡령할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '.1',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: 'TM',
      CPT_WASH_TI_NM: '보험 고객 인적사항의 도용을 통한 고객 보험료 횡령',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '설계사 ○○○는 계약자 ○○○의 신용정보를 계약자 동의 없이 이용하여 ARS대출을 통해 5백만원을 계약자 통장에 입금시킨 후, 계약자에게는 회사공금이 착오 입금되었다고 하여 동 금액을 계약자로부터 반환받아 횡령',
      CPT_WASH_ID: '00000000000000000031',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험설계사가 고객 인적사항을 도용하여 고객의 보험료를 횡령할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '.01',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '2',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 고객 인적사항의 도용을 통한 고객 보험료 횡령',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '설계사 ○○○는 친분이 있는 계약자 ○○○의 신용정보와 동인이 맡겨둔 신분증을 이용하여 ○○보험회사 보험카드를 발급받아 ATM기에서 보험계약대출금 95만원을 인출하여 횡령',
      CPT_WASH_ID: '00000000000000000032',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험설계사가 고객 인적사항을 도용하여 고객의 보험료를 횡령할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '.0095',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '14',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '법인 자금 횡령 후 문서 위조를 통한 횡령 사실 은폐',
      BZC_DSC_NM: '비은행 금융기관(은행 이외 제2금융권)',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '자산운용부 대리 ○○○는 만기해지한 정기예금 중 18건(합계 30억원)에 대하여 만기예금 출금증을 작성한 후 해당은행에 직접 방문·인출하여 회사의 당좌계좌로 송금하지 아니하고 사고자의 증권계좌 및 은행계좌 등으로 입금한 후 사고자가 관리하는 자산관리시스템내의 정기예금 자료를 허위 조작하여 횡령금액에 상응하는 정기예금 자산을 보유하고 있는 것처럼 은폐하는 방법으로 횡령\r\n\r\n ․감사실의 시재검사시 전산상의 원시자료가 아닌 사고자가 허위 작성한 「예금운용상황표」를 제출하고 감사실은 이를 기초로 실물대사\r\n\r\n  → 「예금운용상황표」 제출시 엑셀시트로 허위계좌를 삽입, 작성하고(예금합산총액을 대차대조표 금액과 일치시킴) 출력시에는 엑셀의 숨기기 기능을 이용하여 허위계좌를 출력되지 않도록 하여 자료 제출 \r\n     * 엑셀시트의 경우, 자동적으로 합산이 이루어지므로 감사자가 세목을 합산하지 않을 것이라는 점을 이용하였으며, 잔액증명서는 허위계좌를 제외한 실제 존재하는 계좌에 대하여만 제출',
      CPT_WASH_ID: '00000000000000000033',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험사 직원이 대리인 자격으로만기해지금을 수령할 수 있다는 점을 이용하여 고객의 제지급금을 횡령할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '30',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '02',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 고객 인적사항의 도용을 통한 고객 보험료 횡령',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '설계사 ○○○는 친분 있는 계약자 ○○○로부터 신분증을 빌려 계약자와 외모가 비슷한 사촌동생을 시켜 동 계약자의 보험계약에서 보험계약대출금 15백만원을 인출받아 횡령',
      CPT_WASH_ID: '00000000000000000034',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험설계사가 고객 인적사항을 도용하여 고객의 보험료를 횡령할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '.15',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2014.08.28)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '국민은행 본점 부문검사 결과(국민주택채권의 횡령)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '주택기금부 직원은 영업점 직원들과 공모하여 ’10.3.18. ～’13.11.14. 기간중 영업점에서 국민주택채권 2,451매 111억 86백만원을 부당하게 현금으로 상환토록 하여 이 중 88억 4백만원을 횡령하였고, 강북지점 직원은 ’11.2.22.～’13.10.11. 기간중 국민주택채권을 상환하여 주택기금부 직원에게 일부를 주고 나머지 23억 83백만원을 횡령하였음. 행신동지점 직원 등 4명은 ’10.3.18.～’13.11.13. 기간중 국민주택채권을 부당하게 상환지급 처리하여 주택기금부 직원에게 전달하고, 그 대가로 금품(2,900만원～1억 2,100만원)을 수수하였음.\r\n강북지점 직원 등 9명은 ’10.3.18.～’13.11.14. 기간중 채권 소지자가 은행에 오지도 않은 상태에서 임의의 제3자 명의로 295회에 걸쳐 국민주택채권 104억 56백만원을 현금으로 상환지급하여 실명확인 및 고객확인 의무를 위반하였음.\r\n\r\n[조치사항]\r\n기관경고, 면직, 정직, 문책경고 및 감봉(상당), 주의적경고 및 견책(상당) 등 국민주택채권 횡령 관련자 51명 조치(1명은 동경지점 부당대출 건과 중복) ',
      CPT_WASH_ID: '00000000000000000002',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '본점의 임직원과 영업점 직원이 공모하여 내부통제 시스템의 취약 및 상호견제 시스템의 한계점을 이용하여 회사에 손실을 초래할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '111',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2014.08.28)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'JP',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '일본',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '국민은행 본점 부문검사 결과(동경지점 부당대출)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '동경지역의 경우 신용등급이 낮은 한국계고객을 상대로 부동산담보 대출을 주로 취급하고 있어 제한된 고객을 상대로 한국계 은행끼리 경쟁하는 시장이나, 2년만에 여신잔액이 약 60% 증가한 동경지점에 대하여 신용리스크 등을 집중 관리했어야 하는 상황이었는데도, 제반 리스크를 적절히 관리하지 못하였음.\r\n동경지점에서 타인명의 분할대출, 담보가 대비 과다대출 등 불법대출이 장기간 지속, 반복되어 2013.7월말 여신잔액 675억엔(약 7,425억원)의 72.6%인 490억엔(약 5,390억원)이 부당하게 취급되었고, 이로 인하여 2013.12.31. 약 75억엔(약 842억원)의 손실이 발생하였으며, 부당대출 취급과 관련한 금품수수 등 다수 직원들의 비위행위가 만연하게 된 결과를 초래하였음\r\n\r\n[조치사항]\r\n기관경고, 면직, 정직, 문책경고 및 감봉(상당), 주의적경고 및 견책(상당) 등 동경지점에 대한 본점의 관리업무 부실에 대해 18명 조치',
      CPT_WASH_ID: '00000000000000000008',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '해외점포 전결권의 합리적 조정 등 여신관련 저도, 규정의 취약점을 이용하여 회사에 손실을 초래할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: '5390',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2013.07.17)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '신한은행 종합검사 결과(여신심사 소홀 등으로 인한 부실 초래)',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '여신심의위원회 등에서는 2003.11.14.∼2009.9.30. 기간중 ㈜◒◒◒ 등 19개 차주에 4,917억원의 기업운전자금, 부동산개발금융(PF대출) 등 취급시 채무상환능력, 사업의 정상적인 진행 가능성 등에 대해 여신심사 등을 소홀히 하여 여신을 취급함으로써 3,080억원의 손실을 초래하였음.\r\n\r\n[조치사항]\r\n과태료 부과 및 기관주의',
      CPT_WASH_ID: '00000000000000000009',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '여신심사 및 여신실행 등 이해상충과 사고발생 위험이 높은 업무간의 직무분리를 제대로 운영하지 않아 대출금이 과다산정되어 회사에 손실을 초래할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '3080',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2013.07.17)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '신한은행 종합검사 결과(파생상품 회계 부당처리)',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '재무제표는 기업의 재무상태 및 재무성과를 공정하게 표시하도록 작성되어야 하는데도 ☯☯☯☯부 및 ☮☮☮☮부에서는 파생상품과 관련한 회계처리를 아래와 같이 부당하게 처리하고 지도를 소홀히 하여 2010 및 2011 사업연도중 영업수익 및 영업비용이 각각 2조 3,461억원, 9,924억원 과대계상되는 등의 파생상품 회계 부당처리 사항이 발생하였음',
      CPT_WASH_ID: '00000000000000000010',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '파생상품과 관련한 회계처리를 부당하게 처리하고 지도를 소홀히 하여 회계처리가 부당처리 될 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '33385',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2013.03.12)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '의조적인 담보 감정가액의 과다산정',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '신협 직원은 브로커와 공모하여 담보의 감정가액을 과다산정, 유효담보가액을 47억원을 초과하여 대출',
      CPT_WASH_ID: '00000000000000000011',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '여신심사 및 여신실행 등 이해상충과 사고발생 위험이 높은 업무간의 직무분리를 제대로 운영하지 않아 대출금이 과다산정되어 회사에 손실을 초래할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '47',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2013.03.12)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '위조된 표지어음 담보 대출',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '◦◦은행 ▵▵▵지점은 위조된 표지어음을 담보로 신규거래처에 기업대출 48억원을 취급',
      CPT_WASH_ID: '00000000000000000012',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '금융회사가 자기앞수표 위‧변조, 대출서류 허위작성 등 외부 사기행위에 대비한 내부확인절차를 소홀히 하고 여신을 제공하여 회사에 손실을 초래할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '48',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2012.09.26)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '대출서류 임의변경',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '영업점에서 은행보관용 대출거래약정서에 기재된 대출기간, 대출금액, 차주명 등을 고객동의 혹은 정정날인과 같이 내규상 정당한 절차를 거치지 않고 약정서 기재항목에 덧쓰거나 수정액 등으로 무단 수정하는 방법으로 임의변경',
      CPT_WASH_ID: '00000000000000000013',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '본점과 영업점간의 명확한 업무처리절차 및 내부통제기준이 제대로 마련되어 있지 않고, 대출취급 실적에만 집착하여 법규 준수의식 결여',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2012.09.26)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '지급보증서 위조',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '은행 영업점장이 위조지급보증서를 지점장실에서 전달해주는 금융사기에 가담하고 그 대가로 금품을 수수',
      CPT_WASH_ID: '00000000000000000014',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '영업점장이 금융사기에 연루되어 회사에 손실을 조래할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2014.04.13)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '법인인감증명서 도용 및 문서위조 등에 의한 금융사고',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '한화생명 직원(A氏)이 법인인감증명서를 도용하고 대표이사 인감 및 문서(지급확약서*)를 위조하여 지인(B氏)에게 제공함으로써, B가 대부업체에서 30억원을 부당하게 대출받게 한 사고.\r\n대부업체는 한화생명에 원리금(30.8억원) 상환을 요청하였으나, 한화생명은 상환을 거절\r\n\r\n[조치사항]\r\nA氏로부터 법인인감증명서 도용 및 문서 위조 사실 등을 시인받고 수사기관에 고발(’13.12.11.) 및 징계면직 조치(’14.3.7.)',
      CPT_WASH_ID: '00000000000000000015',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '06',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '직원이 법인인감증명서를 도용하고 문서등을 도용하는 등 내부통제 시스템 취약 및 직원의 도덕적 해이로 인해 회사에 손실이 초래될 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: '30',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '주금가장납입 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2012.09.26)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '고객예금 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '은행 직원이 고객에게 약속한 손실 보전을 위해 배우자를 통해 주식투자를 시작한 후, 주식투자 손실이 계속되자 다른 고객의 정기예금 등을 무단 해지하는 등의 방법으로 고객예금을 횡령',
      CPT_WASH_ID: '00000000000000000016',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '과도한 주식투자로 인해 발생한 손실을 무단으로 고객의 예금을 주식투자에 이용하여 회사에 손실을 초래할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2010.12.29)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '외환은행 금융사고',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '前 선수촌WM센터지점장 △△△(사고자)는 ’06.7.11.～’10.2.16. 기간중 임의 보관하던 고객 통장, 인감 등을 이용하여 ○○○ 등 12명의 예금 등 683억 21백만원을 부당 인출하고,  ◇◇◇ 등 6명의 해외 투자 청산이익 47백만원을 고객 몰래 편취하는 등 총 683억 68백만원을 횡령, 횡령자금을 재원으로 ’08.2.4.～’10.3.4. 기간중 ㈜◎◎◎◎◎◎ 등에게 519억 34백만원을 사적 금전대여.\r\n- 사고자는 ’08.1.30.～’09.7.31. 기간중 현저히 높은 금리(연 7.0～15.0%)로 795억 49백만원의 예금을 유치하였고, 예금주를 안심시키기 위해 사적 금전대여를 한 차주가 은행과 특정금전신탁계약을 체결한 것처럼 계약서를 허위 작성하여 교부\r\n- 대출업무 담당자는 ’08.7.7.～’08.9.2. 기간중 2건(72억원)의 대출을 취급함에 있어 차주와 담보제공자가 내점하지 않았고, 대출신청 또는 담보제공의 의사표시도 없었음에도 사고자의 지시에 따라 임의로 대출업무를 처리\r\n\r\n[조치사항]\r\n외환은행 선수촌WM센터지점(서울 송파구 방이동 소재)은 2011.2.1.부터 2011.4.30.까지 은행법에서 정하고 있는 은행업무․부수업무 및 겸영업무 전부의 신규 취급이 정지됨',
      CPT_WASH_ID: '00000000000000000017',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '직읜이 고객의 예금 및 투자수익을 횡령하르로써 회사에 손실을 초래할 위험\r\n자금세탁 혐의거래 보고담당자가 법죄에 가담되어 회사가 자금세탁 범죄에 이용될 위험\r\n대출업무 담당자가 범죄에 가담되어 회사에 손실을 초래할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '730',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2010.10.06)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '경남은행 금융사고 - 허위지급보증 및 대출채권양수 계약 부당 체결',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '사고자(구조화금융부장 ○○○)는 특정금전신탁에 편입한 대출이 부실화되자 이를 다른 신탁대출로 상환하는 행위를 ’06.12.28.이후 반복하던중 부실금액이 확대되자 은행장인감증명서를 도용하고 사용인감을 위조하여 허위 지급보증서를 교부하거나 채권양수도계약을 부당 체결하는 방식���로 ’07.11～’10.4. 기간중 사고자 관련업체 명의 등을 이용하여 49건 3,440억원을 대출 받아 사용\r\n- 특정금전신탁 재산 부당 운용\r\n사고자는 ’08.4.17～’09.10.30 기간중 위탁자 5개사로부터 수탁한 특정금전신탁 자금 713억원을 위탁자의 운용지시와 달리 경남은행의 부실 신탁대출금 상환, 사고자가 허위 지급보증에 의해 조달한 대출금 상환 등에 부당 사용\r\n- 공동대주 여신에 대한 담보예금 임의지급\r\n‘08.3.6 ○○○종금과 공동대주로 △△△(유)에게 400억원 대출시 ○○○종금 대출금 150억원에 대하여 담보설정 없이 임의 지급하여 부실화\r\n\r\n[조치사항]\r\n은행 특정금전신탁 일부 업무(신규계좌 개설) 3월간 정지(’10.10.11~’11.1.10) 및 은행장 문책경고 조치를 결정하였음',
      CPT_WASH_ID: '00000000000000000018',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '06',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '특정금전신탁 업무 등과 관련하여 대규모 금융사고 및 위법, 부당행위가 장기간에 걸쳐 반복적으로 발생하여 거액의 손실을 초래할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '3440',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '주금가장납입 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '실명확인 위반 및 임의 계좌 해지',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '○○은행 △△지점 조사역 ○○○는 고객 ○○○명의의 정기예금을 임의로 중도해지하여 총 600백만원을 횡령, 정기예금의 만기일이 도래하여 고객이 이를 재예치하는 과정에서 발견',
      CPT_WASH_ID: '00000000000000000019',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '직원이 임의로 예금주의 계좌 개설 및 해지를 통한 자금 횡령의 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.06',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료\r\n(2012.09.26)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '표지어흠 위,변조',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '은행 영업점장이 위·변조 표지어음담보 사기대출에 이용될 표지어음 원본을 유출하고 그 대가로 금품을 수수',
      CPT_WASH_ID: '00000000000000000020',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '영업점장이 금융사기에 연루되어 회사에 손실을 조래할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '상환된 견질어음 할인 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '○○은행 △△지점 ○○○는 여신거래업체인 ○○수산이 융자담보로 제공한 견질어음을 대출금 상환 후 폐기 처분하지 않고 2004.7.7. ○○회사 명의로 할인하여 10백만원을 횡령',
      CPT_WASH_ID: '00000000000000000021',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '상환된 견질어음 들이 폐기처분 되지 않고 횡령 및 유용에 사용될 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.1',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례\r\n(2005.09)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '타인 예금을 담보로 한 부당대출',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '○○은행 비서실장 ○○○는 △△지점 및 △△지점에 지점장으로 근무시 2000.3.16. ~2003.11.17. 기간중 ○○○(처 이모부)명의 예금을 담보로 원화일반대출 2건 579백만원 및 외화대출 1,020천미달러(1,177백만원)를 부당 취급하여 횡령',
      CPT_WASH_ID: '00000000000000000022',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '직원이 타인의 예금을 임의로 담보로 하여 대출받아 대출금을 횡령할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: '.2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_08',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '08',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '부품 거래명세표 위․변조 ',
      BZC_DSC_NM: '건설업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'A건설은 ‘14.5월 경기 화성시에서 발생한 차량사고로 파손된 충격흡수기를 수리한 후 F산업(제조업체)의 거래명세표가 아닌 다른 양식에  F산업(제조업체)의 법인인장 사본을 오려 붙이는 수법으로 255만원의 보험금을 편취하는 등 동일 수법으로 20건에 1억원의 보험금을 편취함',
      CPT_WASH_ID: '00000000000000000098',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '문서 위조를 이용한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_09',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '08',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '간이영수증 등으로 부품내역 허위기재',
      BZC_DSC_NM: '건설업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'B건설은 ‘12.12월 경기 남양주시에서 발생한 차량사고로 파손된 충격흡수기를 수리한 후 충격흡수기 후면지지대를 교환하지 않았음에도 교환한 것으로 간이영수증에 허위 기재하는 수법으로 460만원의 보험금을 편취하는 등 동일 수법으로 2건에 1,400만원의 보험금을 편취함 (* 후면지지대 : 충격흡수기의 끝부분에 설치된 충격완화 부품)',
      CPT_WASH_ID: '00000000000000000099',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '문서 위조를 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.14',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_10',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '08',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '부품단가를 부풀려 청구',
      BZC_DSC_NM: '건설업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'C건설은 ‘14.4.8. 경기 성남시에서 발생한 차량사고로 파손된 충격흡수기를 수리한 후 실제 파손된 충격봉(CC2, 단가 : 33만원)보다 약 2배 비싼 상위모델(CC3, 단가: 60만원)의 단가로 부풀려 884만원의 보험금을 편취하는 등 동일 수법으로 7건에 3,900만원의 보험금을 편취함(* 충격봉 : 충격흡수기내에 설치된 2개의 봉으로 충격시 부서지면서 충격을 완화)',
      CPT_WASH_ID: '00000000000000000100',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '단가를 부풀려 보험금 과다 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.39',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_11',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '품질보증서 허위발급',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'Z정비업체는 ’11.8.8. 1차사고로 에쿠스 차량이 입고되자 유리막코팅 일자가 ‘11.4.25.로 기재된 품질보증서(보증기간 1년)를 S화재에 제출하여 보험금(13만원)을 수령함  \r\n이후 동 차량이 ‘11.8.26. 2차사고로 입고되자 Z정비업체는 재차 유리막코팅후 1차사고시 S화재에 제출하였던 품질보증서상 최초 코팅일자와 다르게 기재(코팅일자 ’11.2.9.)된 품질보증서를 D화재에 제출하여 보험금(24만원)을 편취하는 등 동일 수법으로 4건에 182만원의 보험금을 편취함\r\n* 최초 시공일자가 서로 다르게 기재된 두 개의 품질보증서를 제출한 것으로 보아 최소한 하나의 품질보증서는 허위 발급된 것으로 추정\r\n(수리시마다 허위 보험금 청구를 위하여 편의적으로 품질보증서를 발급)',
      CPT_WASH_ID: '00000000000000000101',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '문서 위조를 이용한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.0182',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_12',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '품질보증서 위・변조를 통한 허위청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'Y정비업체는 ’11.8.18. 사고로 입고된 베라크루즈 차량에 유리막코팅후 D화재에 품질보증서(일련번호896, 최초 시공일자 ‘11.2. 26.)를 제출하여 보험금(20만원)을 수령함\r\n이후  Y정비업체는 ‘12.2.24. 사고로 입고된 소나타 차량에 대하여 유리막코팅후 위 베라크루즈 차량의 품질보증서에 차종과 차량번호를 임의 변경하여 S화재로부터 25만원의 보험금을 편취하는 등 동일 수법으로 5건에 161만원의 보험금을 편취함',
      CPT_WASH_ID: '00000000000000000102',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '문서 위조를 이용한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.0182',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_13',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '사무장이 의료기관을 개설하여 보험금 편취',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '사무장 C는 비의료인으로 의료기관을 개설할 수 없으나 의사 D와 계약하고 A한방병원 개설하고 운영하여 민영보험금 2.8억원 및 건강보험 요양급여 5.9억원을 편취 \r\n이후 사무장 C는 의사 E와 계약을 하고 병원명과 대표자명만 바꿔 재개설하였고 사무장병원 운영을 통해 민영보험금 5.3억원 및 건강보험 요양급여 10.1억원을 편취',
      CPT_WASH_ID: '00000000000000000103',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '의료기관을 개설할 수 없는 사무장이 병원을 개설하여 보험금 편취',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '10.1',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_14',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '사무장 병원의 허위진단을 통한 보험금 편취',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '사무장 F는 지인들과 공모하여 의사 G 등 의사 5명의 명의만 대여하여 사무장병원 2개를 개설하고 운영하여 민영보험금 29.9억원 및 건강보험 요양급여 19.2억원 및 산재급여 0.4억원을 편취한 혐의로 구속 송치\r\n간호팀장 H는 간호사들에게 허위환자들의 의무기록을 조작하도록 지시하고 환자의 핸드폰을 보관해주는 등 보험사기를 방조하였으며,\r\n가짜환자 I 등 61명은 장기간 허위입원하며 보험금을 편취하였고, 특히, I는 1년 6개월 동안 총 217일, J는 1년 동안 358일 허위입원하고 병원에 가짜환자를 유치한 혐의로 I와 J는 구속 송치\r\n브로커 K는 허위입원하는 환자들에게 수수료 20~50만원을 받고 병원을 소개해주어 총 950만원을 편취한 혐의로 구속 송치',
      CPT_WASH_ID: '00000000000000000104',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '30',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_103',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '불법 사무장병원 운영자와 허위환자가 공모한 보험사기',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n非의료인이 사무장병원을 수차례 개설·운영하면서, 허위입원 환자들을 유치하여 입원사실이 없는 환자를 입원한 것처럼 진료기록부를 조작하고 고용된 물리치료사가 없음에도 허위청구\r\n- 사무장 1명 구속, 의사·병원관계자 및 허위입원환자 등 82명 불구속 송치하고, 민영보험금 4.3억원 및 건강보험 4.2억원을 적발 (‘15.1월 검찰 송치)\r\n\r\n[특이사항] \r\n과거에 운영했던 병원의 허위입원 환자들을 유치하였고, 부부가 사무장으로 활동한 기존의 2개 병원도 수사 적발된 전력이 있을 정도로 상습적으로 불법행위를 자행',
      CPT_WASH_ID: '00000000000000000188',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위환자를 유치하여 진료기록부를 조작하는 등의 방법으로 보험금을 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.6',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '05',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_105',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '17',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 렌트계약서를 이용한 보험금 편취',
      BZC_DSC_NM: '자동차정비업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\nA렌트업체 등 3개 업체는 임차인이 작성한 렌트카 임대차 계약서(차종, 임대기간 등)를 수정하거나, 별도의 임대차 계약서를 허위로 작성하고 이를 보험사에 제출하여 렌트비 58백만원 편취 (‘15.3월 검찰송치)\r\n\r\n[특이사항] \r\nA렌트업체 등은 보험사가 서류로 렌트비를 지급하고 보험사의 사실조사가 어려운 점을 악용',
      CPT_WASH_ID: '00000000000000000189',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험사가 사실조사 없이 서류만으로 비용을 지급한다는 점을 악용할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.6',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_106',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '차량을 담보물로 제공 후 허위 도난 신고하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n채무자 A씨는 채권채무 관계가 있는 채권자 B씨에게 채무의 담보로 고가의 외제차를 인도한 후 마치 누군가가 몰래 절취하여 도주한 것처럼 허위 도난 신고하여 보험금 19백만원 편취 (‘15.6월 검찰송치)\r\n\r\n[특이사항] \r\nA씨는 경찰서에 차량 도난 신고 후 발급받는 도난신고확인서를 보험사에 제출하면 도난보험금을 수령 받을 수 있음을 악용하여 담보물로 제공한 차량을 허위 도난 신고',
      CPT_WASH_ID: '00000000000000000190',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위로 도난신고확인서를 발급받아 보험금을 수령할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.6',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_107',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '高價 외제차량을 이용한 편취금액 확대사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '① A렌트업체(경기 소재)는 ’13.3월부터 ’13.11월까지 9개월간 동일 외제차량(아우디)을 이용하여\r\n- 6건(중복일자 10일)의 이중청구를 통해 3개 보험회사로부터 렌트비 2,067만원을 편취하였으며, \r\n- 특히, ’13.10.7.부터 ’13.11.1.까지 4차례나 연속적으로 렌트비를 이중청구하는 행태를 보임\r\n\r\n② B렌트업체(경남 소재)는 ’12.5월부터 ’13.7월까지 15개월간 동일 외제차량(벤츠)을 집중적으로 이용하여\r\n- 12건(중복일자 13일)의 이중청구를 통해 4개 보험회사로부터 렌트비 1,618만원을 편취\r\n\r\n③ C렌트업체(인천 소재)는 동일 외제차량(벤츠)의 렌트기간이 17일간 중복*되는 렌트비 청구서류를 작성하여\r\n    * 렌트기간 ① : ’12.12.8.～’13.1.7./ 렌트기간 ② : ’12.12.12.～’12.12.28.\r\n- 2개 보험회사에 렌트비를 이중으로 청구하는 방법으로 렌트비 933만원을 편취',
      CPT_WASH_ID: '00000000000000000191',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '렌트비를 이중으로 청구하여 렌트 비용을 편취할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.6',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_108',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '동일 차량을 상습적으로 이용한 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'D렌트업체(경남 소재)는 ’12.1월부터 ’13.8월까지 20개월간 동일 차량(YF쏘나타)을 집중적(월평균 1회)으로 이용하여\r\n- 19건(중복일자 30일)의 이중청구를 통해 7개 보험회사로부터 렌트비 1,001만원을 편취',
      CPT_WASH_ID: '00000000000000000192',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '렌트비를 이중으로 청구하여 렌트 비용을 편취할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.6',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_109',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '동일 차량을 여러 업체에서 반복적으로 이용한 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'E렌트업체(전북 소재)가 ’12.8월부터 ’13.8월까지 14건(렌트비 708만원)의 이중청구에 사용했던 3대 차량(YF소나타 2대, 그랜저TG 1대)이 \r\n- F렌트업체(충북 소재)에서 ’13.9월부터 ’14.9월까지 11건(렌트비 597만원)의 이중청구에 재사용\r\n ※ 소재지간 물리적 거리, 양 렌트업체가 계속 영업중인 사실 등을 감안할 때, 차량 양수도 등을 통한 범죄수법 전파가 의심됨',
      CPT_WASH_ID: '00000000000000000193',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '렌트비를 이중으로 청구하여 렌트 비용을 편취할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.6',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_20',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '장해를 허위로 꾸며 장해보험금 부당 청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\nA모씨는 화장실에서 넘어져 두개골 골절 및 뇌출혈을 진단받은 후, 본인이 가입한 보험 계약상 신경계․정신행동 장해 판정시 고액의 보험금이 지급되는 점에 착안하여,장해가 있는 것처럼 가장하여 진단서를 발급받아 1억3천만원의 보험금 편취 시도 (‘14.9월 검찰 송치)\r\n\r\n[특이사항] \r\nA모씨는 장해 판정을 받기 위해 난간을 잡지 않고서는 계단을 오를 수 없고, 혼자서 옷을 입고 벗을 수 없는 것처럼 행동하는 등 사전에 치밀하게 계획',
      CPT_WASH_ID: '00000000000000000166',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1.3',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_21',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자동차 허위도난 신고를 통한 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\nA모씨는 출고된 지 오래되지 않은 고가 자동차를 중고로 매입한 뒤 고액의 자동차보험(자기차량 담보) 계약을 체결하고, 보험가입 3개월 후 매입차량을 도난당했다고 허위로 신고하여 보험금 4천 1백만원을 편취 (‘14.10월 검찰송치)\r\n\r\n[특이사항] \r\n폐차 직전의 차량을 저가 매입하여 동 차량의 번호판을 허위 도난차량에 부착하여 운행',
      CPT_WASH_ID: '00000000000000000167',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위 도난 신고를 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.41',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_22',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '17',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '차량 고의 파손을 통한 차량수리비 편취',
      BZC_DSC_NM: '자동차정비업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n○○카센터 대표 A모씨는 차량 외부를 벽돌 등으로 고의 파손한 후, 가해자 불명 사고 또는 운행중 사고에 의한 다수 차량 파손으로 위장하여 2억 4천만원 상당의 차량 수리비 편취 (‘14.9월 검찰송치)\r\n\r\n[특이사항] \r\n○○카센터는 영업사원 7명을 고용하여 작은 흠이 있는 노후차량이나 경미한 사고를 당한 차량의 차주에게 연락하여 자기부담금을 면제해주는 조건으로 수리를 유도하거나, 주차된 차량에 ‘자기부담금 면제조건으로 차량 수리 가능‘의 내용이 기재된 명함을 꽂아 수리대상을 확보',
      CPT_WASH_ID: '00000000000000000168',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고의적 보험 사고 유발을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '2.4',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_27',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '일가족이 다수의 보험에 가입 후 허위진단을 통한 보험금 수령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '광주에 거주하는 ◯모씨 등 일가족 4명은 총 103개의 보험에 가입하고, 이 중 질병입원시 최대 57만원의 보험금(상해시 최대 51만원)을 수령할 수 있도록 47개의 보장성보험을 유지하면서, 허리뼈의 염좌 및 긴장 등의 사유로 1,542일간 입원하여 A생명 등 16개 보험회사로부터 총 7.4억원의 보험금을 수령\r\n특히, 일가족은 한방병원(한의원) 등 8개 병원에서 100여일간 동반으로 입원하는 등 비정상적 입원패턴을 보이기도 함',
      CPT_WASH_ID: '00000000000000000169',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '7.4',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_28',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '일가족이 다수의 보험에 가입 후 허위진단을 통한 보험금 수령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '서울에 거주하는 △모씨 등 일가족 4명은 질병으로 입원할 경우, 최대 49.5만원(상해시 최대 30만원)의 보험금을 수령할 수 있도록 총 46개 보장성보험에 가입한 후, 경미한 \'상세불명의 머리손상\', ‘무릎관절증’ 등으로 총 2,450일 동안 입원하고, B손보 등 18개 보험회사로부터 총 9.1억원의 보험금을 수령\r\n특히, 주혐의자 △모씨는 ‘목욕탕에서 미끄러지는 사고’ 등 목격자 없는 허위의심 단독 상해사고로 다수(37회, 853일) 입원하는 패턴을 보임',
      CPT_WASH_ID: '00000000000000000170',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 고의사고를 통한 보험금 편취',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '9.1',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_32',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '합의금 과다 편취를 위한 단기 입․통원치료 반복',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요]\r\n혐의조직 E는 36건의 경미한 고의사고(평균 수리비 114만원)를 야기하고 상해가 없음에도 단기간 입원(평균 2.9일) 및 통원(평균 1.2일) 치료를 반복하여 총 72백만원의 합의금을 편취\r\n → 전체 혐의자는 평균 4.2일 입원 및 1.1일 통원치료를 받고 1 사고당 263만원의 합의금 편취',
      CPT_WASH_ID: '00000000000000000171',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고의적 보험 사고 유발을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '7.2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_36',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '17',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '구식 중고차, 고급튜닝 등 피해과장',
      BZC_DSC_NM: '자동차정비업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요]\r\n(고가 튜닝차량 등 피해과장) 혐의자 C는 ‘13. 4월경 경미한 사고로 자신의 BMW 스포츠 세단 휀더의 일부만 파손되었음에도, 휠․타이어․외장랩핑․서스펜션 등 고가의 사제튜닝 제품이 모두 파손되었다며 15백만원 상당의 수리비를 부풀려 청구하여 이중 일부를 미수선수리비로 편취하는 등 조사대상기간 중 BMW 외 3종의 외제차량을 이용하여 25회의 사고로 1억 2천만원의 미수선수리비를 편취\r\n혐의자는 자동차 경주장(서킷)에서 발생한 사고를 일반 교통사고로 위장하여 보험금을 편취하였을 것으로도 추정*\r\n(중고 희귀차량 이용) 혐의자 D는 연식이 10년 이상된 혼다 시빅 등 4종의 희귀 외제차량을 저가에 구입하여 16회의 고의사고로  7천만원의 미수선수리비를 편취',
      CPT_WASH_ID: '00000000000000000172',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험 사고 발생 시 사고를 부풀려 보험료 과다청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.7',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_38',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '병원 사무장·환자 공모를 통한 건강․민영보험금 편취',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요]\r\nOO병원 사무장 A모씨는 실질적으로 병원을 소유․운영*하면서 입원이 필요하지 않은 환자들의 장기·반복입원을 묵과 혹은 방조하고 허위서류를 발급해 주는 수법으로, 환자들이 약 1억 7천만원의 입원보험금을 편취하는데 도움을 주었고, 병원은 건강보험금을 편취(‘14.2월 검찰 송치)\r\n\r\n[특이사항] \r\n사무장 A모씨는 허위진단서 발급 등을 통해 보험금을 쉽게 받을 수 있게 해준다고 환자들을 유치하여 병원을 운영',
      CPT_WASH_ID: '00000000000000000173',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1.7',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '06',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_39',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '장기·반복 입원을 통한 일가족 보험사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '[사건개요]\r\n A모씨 등 일가족 3명은 염좌, 추간판탈출증 등 통원치료가 가능한 경미한 질병으로 병원을 옮겨 다니며, 약 2,040일을 장기·반복 입원하는 수법으로 총 5억 7천만원의 보험금을 편취(‘14.4월 검찰 송치)\r\n\r\n[특이사항] \r\n총 15개 보험회사에 약 100여건의 보험을 가입하면서, 일반적 보험가입과 동떨어진 비상식적 보험가입 행태를 보임 ',
      CPT_WASH_ID: '00000000000000000174',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '5.7',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_42',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '17',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '이륜차 렌트업자의 계약서 조작',
      BZC_DSC_NM: '자동차정비업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n이륜차 렌트업체 대표 A모씨는 고객(피보험자)에게 소정의 현금을 제공하는 조건으로, 대여하지 않은 차량을 대여한 것처럼 서류를 꾸미거나 대여기간을 부풀리는 방식으로 계약서를 위조하여, 6천6백만원의 보험금을 편취(‘14.6월 검찰송치)\r\n\r\n[특이사항] \r\n피보험자와 사전공모가 있는 경우 보험사의 사실조사가 쉽지 않고 서류만으로 렌트비를 지급하는 점을 악용',
      CPT_WASH_ID: '00000000000000000175',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '문서 위조를 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.66',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '07',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_43',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '불법 수집한 고객정보를 활용한 보험사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\nA모씨는 휴대폰판매업을 통해 취득한 고객정보 30여건을 빼돌려 지인들과 공모하여 고의사고를 야기 후, 해당 고객 명의의 대포통장을 개설하여 약 1억 3천만원의 보험금 편취(‘14년 3월 검찰송치)\r\n\r\n[특이사항] \r\n소액일 경우 보험사 업무처리를 간소화하기 위해 유선으로 합의하는 과정에서 정확한 신분확인이 어려운 점을 악용',
      CPT_WASH_ID: '00000000000000000176',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고의적 보험 사고 유발을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1.3',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_46',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사가 본인과 가족을 동원하여 허위․과장 입원',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요]\r\n보험설계사 A는 가족 2명과 함께 기존 가입한 44개의 보험상품을 惡用하여 2006년 이후 총 32～41회에 걸쳐 허위 ․ 과다 입원하는 수법으로 총 314백만원을 편취(각 징역 1년～2년) \r\n입원필요성이 없는 경미한 질병으로 장기간 입․퇴원을 반복하고 입원기간 중 수시로 외출하였음에도 입원일당 등 지급청구',
      CPT_WASH_ID: '00000000000000000177',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '3.14',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_47',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사가 지인과 공모하여 허위로 무릎수술 유도',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '[사건개요]\r\n보험설계사 B는 보험계약자 甲에게 고액보험금 수령이 가능한 보험상품 추천 및 허위진단서 발급이 용이하고 장기입원이 가능한 병원에 대한 정보를 제공하여 甲이 15개 보험상품에 집중 가입 후 허위 무릎수술 및 장기 입원하는 방법으로 51백만원의 보험금을 편취하도록 유도(甲:징역 4월)',
      CPT_WASH_ID: '00000000000000000178',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.51',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '05',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_48',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '○○ 가축보험 담당자가 가축주와 공모하여 사고 조작',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요]\r\n○○직원 C는 가축주와 함께 밧줄을 이용해 고의로 소를 넘어뜨린 후 사진을 찍어 고관절 탈구로 인해 긴급도축이 불가피한 소로 위장하거나, 실제 골절로 쓰러졌던 소의 사진에 포토샵으로 보험처리 할 소의 개체식별번호 사진을 삽입하는 수법 등으로 보험금 총 550백만원을 편취(징역 2년, 집행유예 3년)',
      CPT_WASH_ID: '00000000000000000179',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고의적 보험 사고 유발을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '5.5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '01',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_50',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '레이싱 중 발생한 사고를 일반사고로 조작',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n동호회 회원들이 자신 소유 자동차로 레이싱경기장에서 경기중 발생한 사고*를 일반도로 운행 중 동물을 피하거나 미끄러져서 발생한 사고로 조작하여 보험금을 부당 수령(19명, 1억4천만원)\r\n자동차를 경기용 또는 경기를 위해 연습용으로 사용하던 중 생긴 손해는 약관상 보상 범위에서 제외\r\n\r\n[특이사항] \r\n보상대상에서 제외되는 고위험의 레저활동 중 발생하는 사고가 증가되고 있는 추세에서, 관련 동호회내 활발한 정보교류에 의해 사기수법이 공유·확산되는 경향',
      CPT_WASH_ID: '00000000000000000180',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험 사고가 아닌 사고를 보험사고로 조작하여 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1.4',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_52',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '렌트카 업체가 대여기간 등을 조작하는 수법으로 사기를 주도',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n렌트카 업체가 대여하지도 않은 차량을 대여한 것처럼 렌트계약서를 작성하거나 대여기간을 늘리는 등의 방법으로 보험금 부당 수령(219건, 3억1천만원)\r\n\r\n[특이사항] \r\n렌트카 업체가 정비업체의 사고현장 출동직원 등과 공모하여 보험사기에 활용할 대상자(자동차사고자)들을 쉽게 모집. 보험회사가 렌트카 업체의 서류만으로 렌트비를 지급하는 점을 악용',
      CPT_WASH_ID: '00000000000000000181',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '문서 위조를 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '3.1',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_53',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '경미한 접촉사고 발생 후, 피해를 과장하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n차량의 범퍼손상도 거의 없는 경미한 추돌사고임에도, 피해를 과장하여 병원에서 상해진단서를 발급받고, 이에 대한 진료비 및 합의금 등을 편취\r\n\r\n[특이사항] \r\n국립과학수사연구원에서 해당사고의 블랙박스 동영상 및 ‘충격량 분석 프로그램(마디모)*’을 통해 피해과장을 과학적으로 밝혀낸 후, 사기혐의자를 보험사기로 기소\r\n * 사고차량의 사고당시 속도, 충격후 밀려난 거리 등을 분석하여 사고가 인적상해에 미친 영향을 알아낼 수 있는 프로그램으로, 가벼운 접촉사고 후 보험금을 노려 병원에 입원하는 사례에 대한 적정성 여부 판단에 활용',
      CPT_WASH_ID: '00000000000000000182',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험 사고 발생 시 사고를 부풀려 보험료 과다청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_93',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '도급업자배상책임보험금 수령 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'B씨는 ‘10.1~\'11.1월 기간동안 벤츠를 운행중 상하수도 공사 구간 및 도로공사 구간 주행으로 차량이 파손되는 사고가 3건 발생하여 각 도급업자가 가입한 배상책임보험에서 차량수리비 등 보험금 5천만원을 수령하는 등 총 12건의 고의 자동차사고로 1억5천만원의 보험금 수령\r\n3건의 배상책임보험 사고 모두 B씨의 주거지 인근 지역에서 야간시간대에 발생\r\nB씨는 자동차보험에서도 주거지 인근 지역에서 중앙선 침범차량, 차선변경 차량 등과 경미하게 접촉하거나 가해자 불명의 사고 등 총 9건의 자동차 사고 경력자',
      CPT_WASH_ID: '00000000000000000183',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고의적 보험 사고 유발을 통하여 보험금을 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1.5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_98',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '08',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사가 인력사무소 소속 근로자를 이용하여 보험금 편취',
      BZC_DSC_NM: '건설업',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n인력사무소를 운영하는 법인대리점 소속 보험설계사 A씨는 인력사무소 소속 일용직 근로자의 명의로 보험계약을 체결하고 허위입원 및 대리입원, 대리 장해 진단 등을 통해 보험금 4.9억원 편취 \r\n- 보험료를 대납한 후 일용직 근로자로 하여금 허위입원 또는 타인 명의로 대리입원토록 하거나 부상을 입은 근로자로 하여금 타인명의로 진단을 받도록 하여 보험금 편취 (‘15.4월 검찰송치)\r\n\r\n[특이사항] \r\n보험관련 전문지식을 가진 보험설계사이며 인력사무소 운영자가 조직적으로 소속 일용직 근로자를 보험범죄에 이용',
      CPT_WASH_ID: '00000000000000000184',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험설계사가 제3자 명의로 보험계약 체결 후 허위 진단을 통하여 보험금 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '4.9',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_99',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '전·현직 보험설계사가 가족·지인과 공모하여 보험금 편취',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\nA씨 등 26명은 22개 보험회사에 다수의 입원특약 보험을 가입한 후 입원할 필요가 없음에도 불구하고\r\n- 염좌, 당뇨, 천식, 위궤양 등의 병명으로 1인당 145일 ~ 1,734일 동안 반복적으로 입․퇴원하여 보험사로부터 총 35억원 상당의 보험금 편취 (‘15.3월 검찰송치)\r\n\r\n[특이사항] \r\n혐의자 중 전·현직 보험설계사 5명이 보험사기를 주도하였으며, 이들은 자신의 보험지식을 바탕으로 병명을 바꿔가며 장기간 입원하여 입원보험금을 편취하였으며, \r\n- 점차 자신의 가족과 지인들까지 동원하여 조직적으로 보험금을 편취하였고, 심지어 고등학생 자녀까지 동원하여 방학 때 마다 입원시켜 보험금 편취',
      CPT_WASH_ID: '00000000000000000185',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '전·현직 보험설계사가 보험 지식을 이용하여 허위 입원하여 보험금 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '35',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_100',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사가 사망진단서 위조로 가족의 사망보험금 부당청구',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\nA씨는 해외 연수중 질병으로 사망하였으나, 보험설계사인 A씨의 친형이 해외 현지 한인들을 통해 부검의를 소개받아 12만원을 주고 매수하여 \r\n- 사망 원인을 상해(구토에 의한 질식)로 변경하여 사망진단서를 허위로 발급받은 뒤 사망보험금 6.2억원을 청구(‘15.4월 검찰송치)\r\n\r\n[특이사항] \r\nA씨 친형은 10년 이상 보험설계사로 일했던 자로 사인이 상해일 경우 보험금을 더 많이 받을 수 있는 점을 악용하여 사망진단서를 허위로 발급받아 제출',
      CPT_WASH_ID: '00000000000000000186',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험설계사가 보험 지식을 이용하여 과대하게 보험금을 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '6.2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_102',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '의사와 보험사기 브로커가 공모한 허위장해 보험사기',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n의사와 브로커가 공모하여 허위장해진단서를 발급하고 보험금을 편취한 사건으로, 의사는 장해진단과정에서 검사 없이 환자에게 기존 검사결과를 오려붙이는 방법으로 장해진단서를 발급  \r\n- 의사 및 브로커 등 12명 불구속 송치하고, 민영보험금 12.6억원 및 건강보험 0.6억원을 적발 (‘15.2월 검찰 송치)\r\n\r\n[특이사항] \r\n병원장, 의사 및 병원사무장 등은 허위장해 진단을 통해 브로커로부터 별도의 금품을 수수하고, 브로커(손해사정사와 그 보조인 등)는 조직적으로 보험금의 일부를 수임료로 배분',
      CPT_WASH_ID: '00000000000000000187',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위장해진단을 통하여 보험금을 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.6',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_112',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '성형수술비를 실손의료보험으로 보장되도록 진료내용 조작',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n광주 C의원 등 2개 병원은 보험설계사와 공모하여 성형수술이나 단순 통원치료만 받아도 실손의료보험으로 청구할 수 있도록 진료내용을 조작하여 허위진단서 등 발급\r\n\r\n[사기수법] \r\n사무장병원으로 운영한 해당 병원은 원무과장이 의사를 대신하여 진료기록부를 허위 작성하여 환자의 입원보험금 청구를 돕게 하거나, \r\n- 환자에게 성형수술이나 피부관리를 시행하였음에도 상해나 질병으로 치료받은 것처럼 허위 진단서 등을 발급\r\n   ※ 공모한 보험설계사들은 가짜 환자가 병원에 지불하는 입원비 중 현금의 5%, 카드금액의 10%를 알선수수료로 수령\r\n  -> 병원은 허위환자 유치를 통해 국민건강요양급여금 6억원을 편취하고 환자는 실손보험금 등 약 7억원을 편취(병원관계자 등 122명 적발)',
      CPT_WASH_ID: '00000000000000000196',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '진료 내용을 조작하여 과다하게 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '52',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_113',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '비의료시설 이용 후 의료기관에서 치료한 것으로 진료비영수증 발급',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n서울 D의원은 비의료시설인 ‘자세교정치료센터’를 동일건물에 운영하며 운동치료 등을 시행하고 실손보험금을 받게 해주겠다며 진료비영수증을 동 의원명의로 발급\r\n\r\n[사기수법] \r\n동 병원은 자세교정치료센터를 운영하는 대표가 무면허 의료행위도 하는 사무장병원으로\r\n- 환자내원시 의원 및 교정치료센터를 번갈아 가며 물리치료․운동치료를 실시한 후 동 병원 명의로 진료비영수증을 허위 발급\r\n -> 병원은 비의료시설을 운영하면서 23개 보험사로부터 실손보험금 20억원을 편취하였고 사무장병원을 운영하여 국민건강요양급여금 23억을 편취(병원관계자 2명 적발)',
      CPT_WASH_ID: '00000000000000000197',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '비의료시설의 이용을 의료시설의 이용으로 조작하여 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '52',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_114',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '전국 20여 곳 병원을 투어하며 반복 입원하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '[사건개요] \r\nA씨 등 일가족 5명은 중복보장이 가능한 보장성 보험 154개 (월 보험료 400만원)를 가입한 후 입원이 필요 없음에도 불구하고\r\n- 무릎연골 이상, 허리디스크 돌출증 및 고혈압 등을 이유로 10년 동안 2,141일을 입원하여 보험회사로부터 8.5억원 상당의 보험금을 편취 (2015.12월 검찰송치)\r\n\r\n[특이사항] \r\n고액의 보험금을 수령하기 위해 입원이 용이한 병원을 찾아 울산, 부산, 김해, 서울, 경기, 대전 등 전국을 투어하며 반복 입원\r\n- 보험사기를 통해 편취한 보험금은 생활비로 사용하거나 보험료를 납부하는데 사용',
      CPT_WASH_ID: '00000000000000000198',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '중복보장이 가능한 보험을 다수 가입하고 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '8.5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_110',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '암환자에게 고주파온열치료 등 치료횟수 부풀려 청구',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n경기도 A병원은 경영이 어렵게 되자, 실손의료보험에 가입한 암환자만을 유치한 후 이들과 공모하여 허위진료비영수증 등 발급\r\n\r\n[사기수법] \r\n병원은 암환자를 대상으로 고주파온열치료 및 면역제 투약횟수 등을 부풀리는 수법으로 진료기록부를 조작*하여 진료비영수증을 발급\r\n- 환자는 과다청구한 보험금 중 실제진료비를 제외한 차액을 생활비로 보전\r\n    * 사례) 고주파온열치료와 자닥신주사를 각각 1회, 4회 시술 및 투약하였으나 각각 11회, 7회 받은 것처럼 허위 진료기록부 작성\r\n - 또한 해당병원은 환자가 실제 입원한 사실이 없거나 입원기간이 아님에도 부풀려서 입원확인서를 발급하였으며, 암환자를 소개한 사람에게 환자 1명당 10만원의 소개비를 지급\r\n  -> 환자들(190명)은 허위 입․퇴원확인서 및 허위 진료비영수증을 근거로 28개 보험사로부터 52억원의 입원보험금 및 실손보험금 편취(병원관계자 6명등 14명 적발)',
      CPT_WASH_ID: '00000000000000000194',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '치료 횟수를 부풀려 과다하게 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '52',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_111',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '고가의 렌즈삽입술을 하면서 수술횟수 및 병명을 조작',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n서울시 B안과의원은 시력교정을 위해 고가의 시력교정 렌즈삽입술을 한 후 백내장수술을 한 것처럼 허위진단서 발급\r\n\r\n[사기수법] \r\n원장은 하루에 시행한 수술을 이틀에 걸쳐 2회 수술한 것처럼 허위 수술확인서를 발급하고, 백내장증상이 없음에도 허위로 진단서를 발급\r\n  -> 환자들(54명)은 백내장 허위진단서 및 수술확인서를 근거로 24개 보험사로부터 2억9천만원 상당의 실손보험금 편취(병원관계자 등 70명 적발)',
      CPT_WASH_ID: '00000000000000000195',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '치료 횟수를 부풀려 과다하게 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '52',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_04',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험대리점을 운영하면서 다수보험 가입 후 보험금 편취',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '보험대리점을 운영하는 김모씨는 특정 성인질병(만성 C형간염)에 대하여 고액의 입원보험금을 지급받을 수 있도록 다수 보험상품에 가입\r\n만성 C형간염은 장기간 입원치료가 필요 없고, 경구용으로 투약되는 약으로 집에서 안정가료를 하며 통원으로 충분한 치료가 가능한 질병임에도,\r\n- 입원기간 동안 보험모집 등을 이유로 매일 외출, 외박하며 실질적으로 통원치료를 받은 후 이러한 사실을 숨기고 입원치료를 받았다는 입원확인서를 보험사에 제출하여 보험금 편취',
      CPT_WASH_ID: '00000000000000000135',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_05',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '입원이 필요 없는 경미한 질병으로 보험금 편취',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '보험설계사 김모씨는 입원일당을 보장하는 16개 보험상품에 가입한 후 입원이 필요가 없는 대장염, 오한 등 경미한 질병으로 병원에 장기 입원하여 보험사로부터 보험금 편취\r\n그의 가족 박모씨 등 2명도 각각 14개 보험상품에 가입하고 입원 필요성이 없는 경미한 질병으로 병원에 장기간 입원한 후 보험사로부터 입원보험금 등 편취',
      CPT_WASH_ID: '00000000000000000136',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_06',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '본인 및 가족을 보험에 가입시킨 후 허위치료를 통하여 보험금 편취',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '보험설계사 조모씨는 염좌 등 경미한 질병으로 장기 입원 중 보험모집 활동을 하는 등 입원치료가 필요 없는 상태였음에도 56회에 걸쳐 반복적으로 입원 후 보험금 편취\r\n또한, 그의 배우자와 자녀 역시 약 처방과 간호기록이 없는 등 실제 입원치료를 받지 아니하거나 약 처방을 받은 것 외에 다른 치료 내용이 없는 등 장기간에 걸쳐 허위 입원하여 보험금 편취',
      CPT_WASH_ID: '00000000000000000137',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_07',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 진료확인서 등을 발급받아 보험금 편취',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '07',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '보험설계사 김모씨는 보험약관상 보장사유에 해당하지 않는 한약을 조제받아 복용하더라도 보험금을 지급받게 해주겠다고 하여 고객을 다수보험에 가입하게 한 후,\r\n한의사와 공모하여 보험가입자에게 보약을 처방하였음에도 치료를 한 것처럼 허위 진료확인서 및 수납영수증을 작성하여 보험금 편취',
      CPT_WASH_ID: '00000000000000000138',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '01',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_56',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자동차보험 관련 사기행위(피해자 끼워넣기형)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요]\r\n교통사고 현장에 없던 사람을 피해자로 끼워넣는 등 사고내용을 조작하여 보험금 편취 \r\n김OO 등은 ‘08.12.11 경북 경주시 OO콘도 주차장에서 정차 중 타인의 승용차에 들이받히는 교통사고를 당한 후, 과실유무 등 사고 처리에 관해 시비 발생 \r\n상대방에게 피해를 확대시킬 의도로 사고 현장에 없었던 지인(2명)을 교통사고를 당한 것처럼 가장하기로 공모(일명 ‘피해자 끼워넣기’) 하여 실제사고자 2명을 포함하여 총 4명이 병원에 입원하고, 합의금 및 치료비 명목으로 보험금을 편취',
      CPT_WASH_ID: '00000000000000000139',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험 사고 발생 시 사고를 부풀려 보험료 과다청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '05',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_57',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자동차보험 관련 사기행위(허위 교통사고 신고형)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '신용불량자',
      CPT_WASH_CNTN: '[사건개요]\r\n허위의 사고를 신고하거나, 단기 보험에 가입한 후 다수의 고의사고를 야기하여 보험금 편취\r\n강OO 등은 신용불량자로서 고액의 보험료를 부담할 수 없는 상황임에도 월 보험료가 200만원 정도의 다수(49건)의 보험(상해보험 및 운전자 보험 등)에 가입\r\n피고인들 간에 차량 충돌사고가 발생한 사실이 없음에도 불구하고, ‘08.5.20. 대구 북구 OO빌라 앞 노상에서 사고가 발생하였다고 허위 신고하는 등 사고를 가장하여 수리비, 치료비, 입원급여금 등의 명목으로 보험금 편취 \r\n\'06. 9월부터 ~ ’11년. 6월 까지 범행횟수가 무려 48회에 이르며, 일부사고는 단기보험에 가입된 차량으로 운전하여 가입기간 중 사고 발생 ',
      CPT_WASH_ID: '00000000000000000140',
      CUS_CHR_C: '02',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고의적 보험 사고 유발을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_58',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '생명․장기보험 관련 사기행위(기존질병 은폐형)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '[사건개요]\r\n타인 명의로 위암 의증 진단을 받았으나, 이를 고지하지 않고 다수의 보험계약을 체결한 후, 암 진단보험금 등을 편취\r\n박OO은 ‘06. 9.19. 순천시 소재 의원에서 지인 명의로 위내시경 및 조직검사를 통해 위암 의증 진단을 받음  \r\n06.9.27.∼9.29 암을 담보 하는 보험계약(총 5건)을 집중 청약하면서 자신의 이름으로 진단받지 않은 점을 악용해 청약서에 동 진단사실을 미고지\r\n약관상 면책기간(90일)이 경과한 ‘07.2.15. 서울 OO병원에서 조직검사를 통해 위암 진단을 새롭게 받은 것처럼 하여 암 진단보험금 및 수술․입원급여금 등을 편취',
      CPT_WASH_ID: '00000000000000000141',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험 부적격자가 부적격 사유를 숨기고 보험 가입 후 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_60',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '생명․장기보험 관련 사기행위(장기 과다입원형)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '[사건개요]\r\n입원일당 및 질병 등을 담보하는 보장성보험에 집중 가입한 후, 경미한 질병으로 장기 입원 치료하여 보험금을 편취하고, 자녀까지 보험사기에 동원\r\n김OO은 ’03.12월 이후 입원일당 및 질병 등을 담보하는 16개의 보장성 보험을 집중 가입 \r\n과거 사고로 인한 ‘아래 팔 골절 진단’ 등으로 ‘05.8월 이후 부산시내 일원 병원에 1,470일 동안 입원(총 44회)하여 입원보험금 등을 지급받았으나, 수시로 외출․외박을 하는 등 치료의 실질은 통원에 불과한 것으로 확인됨 \r\n한편, 김OO은 입원급여금이 120일을 최고한도로 지급되는 점을 악용하여 해당 기간 경과시 새로운 재해를 유발하는 등의 수법을 보임\r\n아울러, 김OO은 아들(당시 16세)을 피보험자로 하여 8건의 보험계약을 체결한 후, 위궤양 등 입원이 필요 없는 질병을 이유로 110일 동안 입원(총 6회)시키고, 관련 보험금을 편취',
      CPT_WASH_ID: '00000000000000000142',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_61',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '생명․장기보험 관련 사기행위(허위진단서 발급형)',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요]\r\n산부인과 의사가 불법낙태 수술한 환자의 진단서를 골반염 등으로 허위로 작성하여 주고 보험금 편취를 방조 \r\n김OO은 경북 영주시 OO산부인과에 찾아온 임신 5∼6주차 산모를 대상으로 ‘09.1.6.이후 ’11.11.25까지 총 696회에 걸쳐 불법낙태를 시행\r\n피고인은 요양급여비를 지급받기 위해 환자의 진단명을 낙태가 아닌 ‘질염, 골반염’ 등으로 허위 기재\r\n환자들이 위 허위진단을 보험회사에 제출하여 보험금을 청구한다는 사정을 알면서도 허위진단서를 작성하여 주는 등 보험사기를 방조 ',
      CPT_WASH_ID: '00000000000000000143',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_62',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 관련 지식을 악용하여 고의적 사고 유발을 통한 보험금 편취',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '보험설계사로 근무하였던 A씨는 ‘08.10월 ~ ’10.1월 중 5건의 운전자보험에 가입한 후 총 36건의 사고로 할증지원금 24.2백만원 수령\r\nA씨는 풍부한 보험지식을 악용하여 사고 내용이 단순하여 다툼의 여지가 없고 사고 유발 또한 쉬운 주․정차차량을 접촉하는 방법으로 21건, 후미추돌 및 단독사고 각각 4건 등 총 36건의 다수의 자동차 사고를 유발하여 고액의 보험금 부당 수령.',
      CPT_WASH_ID: '00000000000000000144',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고의적 보험 사고 유발을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.242',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_88',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '의료소비자생활협동조합 부속 의료기관',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'OO의료생협 이사장은 부속의료기관으로 충주 OO의원을 개설한 후 배우자를 원무실장으로 근무토록 하면서 환자들의 허위입원을 유도\r\n주부 최○○는 입원기간 동안 강원도 카지노에 수시로 출입하고, 돈이 떨어지면 다시 허위입원 처리하는 등의 방법으로 9회에 걸쳐 5천만원의 보험금을 수령하여 도박자금으로 탕진\r\n전직 설계사 이○○는 허위입원으로 보험금 3천만원을 부당 수령하고, 친인척들에게 “보험에 들어 놓고 보험금을 못타면 바보”라며 보험사기 수법을 알려주면서 보험사기에 함께 가담',
      CPT_WASH_ID: '00000000000000000145',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_89',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '1개 의원급 의료기관에서 가짜환자 등 455명 무더기 적발',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '병원 사무장 고○○는 의료기관 개설이 가능한 비영리법인의 명의를 빌려 인천 OO의원을 개설\r\n환자들은 “입원하지 않아도 보험금을 잘 받을 수 있게 처리해준다”는 소문을 듣거나, 보험사기 브로커의 소개(건당 7만원)를 받아 해당 의원을 방문하여 허위입원 후 보험금을 청구\r\n해당 의원은 입원환자의 혈압과 맥박을 똑같이 기록하는 등 진료기록부를 허위로 작성하기도 하였음',
      CPT_WASH_ID: '00000000000000000146',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_90',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '사무장 부부가 운영하는 한의원',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '사무장 김○○씨 부부는 자금압박으로 고민하던 한의사 강○○를 원장으로 고용한 후 각각 병원 이사장, 부원장 행세를 하며 입원기간 등이 조작된 허위진단서를 남발\r\n내원 환자들에게 “바쁘면 오지 않아도 되고 자유롭게 왔다갔다해도 된다, 핸드폰은 맡겨라” 등 외출외박에 따른 입단속을 강조하며 허위 입원환자를 유치\r\n한의원 실내 인테리어 공사를 하였던 박○○에게 공사비를 지불하는 대신 23일간 입원한 것으로 가짜 진단서를 발급해 주어 보험사로부터 190만원을 지급받게 함',
      CPT_WASH_ID: '00000000000000000147',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_91',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '불법 낙태와 무자격 성형수술까지',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '산부인과 전문의 최○○는 사무장과 공모하여 병원수익금을 나누는 조건으로 대전에 OO의원(정형외과)을 설립\r\n조직폭력배, 택시기사, 대학강사, 보험설계사, 회사원, 가정주부에 이르기까지 다양한 계층의 가짜환자들이 병원과 공모하여 보험금을 부당 수령(해당 의원에 근무 중인 간호사도 가짜환자에 포함)\r\n대학강사 강○○는 경미한 상해로 1인실에 5개월간 장기입원하면서 병실열쇠를 본인이 직접 관리하고 자유롭게 출·퇴근하며 1천3백만원의 보험금을 부당 수령\r\n해당 의원은 부수입을 올리기 위해 자연 유산된 것처럼 검사결과를 조작한 후 불법적인 낙태수술을 시행하였으며, 전직 간호조무사를 고용하여 쌍꺼풀과 앞트임, 옆주름 성형수술을 하는 등 불법 시술',
      CPT_WASH_ID: '00000000000000000148',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통하여 보험금을 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '05',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_92',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '17',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '지자체배상책임보험금 수령 사례',
      BZC_DSC_NM: '자동차정비업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'A씨는 ’10.9~‘11.7월 기간동안 4건의 도로하자로 인한 차량파손 사고로 각 지자체가 가입한 배상책임보험에서 차량수리비 등 보험금 28백만원 수령\r\n동 차량은 일반차량에 비해 차체가 낮게 개조된 벤츠 차량으로 지면과 파손구간의 차이에 의해 휠, 타이어 등이 파손되었다며 동종동형의 부품 재조달을 주장하여 수리비를 과대산정\r\n차량수리비를 지급받은 후 별다른 수리 없이 운행 중 또 다른 자동차사고를 야기하여 동일부위에 대한 차량수리비 재차 수령',
      CPT_WASH_ID: '00000000000000000149',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고의적 보험 사고 유발을 통하여 보험금을 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_65',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 입원 ',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '이OO(여, 50세)는 실제 수술이 필요하지 않음에도 고액의 보험금을 받기 위해 고의로 수술을 하거나 허위 입원하는 등 36회에 걸쳐 812일 입원하여 11개 보험회사로부터 1억 6천만원의 보험금을 편취',
      CPT_WASH_ID: '00000000000000000150',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1.6',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_66',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '일가족 보험사기 ',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '구OO(여, 51세)등 일가족 5명은 16개 보험회사에 26개 보험을 가입한 후, 최근 2년 동안 40회 908일 허위입원 등을 통해 총 2억 3천여만원의 보험금을 부당수령',
      CPT_WASH_ID: '00000000000000000151',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '2.3',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_67',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '브로커 허위입원 알선',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '병원 직원의 부친이 브로커로 활동하면서 환자 1명당 5만원～30만원을 받고 허위입원을 알선하였으며, 본인을 포함한 자녀까지 동원하고 입원 및 수술을 하여 총 2천여만원의 보험금을 편취',
      CPT_WASH_ID: '00000000000000000152',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_68',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '의사의 불법행위',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '병원장 김OO(남, 49세)는 의사자격이 없는 의료기 업체 직원 등에게 마취 및 수술을 지시하였고, 환자를 고의 수술·허위 입원시킨 후 공영보험에서 10억원 상당의 급여를 부당수령',
      CPT_WASH_ID: '00000000000000000153',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '10',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_69',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '진료행위 없이 숙식만 제공하는 모텔형 병원 보험사기 적발',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '대형병원 근처에서 암환자 등에게 특별한 진료행위 없이 숙식만 제공하며 허위진단서 등을 발급하는 서울지역 4개 병원 관계자 및 환자 적발\r\n적발된 사무장들은 고령의 의사들을 고용하여 진료기록부를 허위로 작성하여 국민건강보험으로부터 요양급여를 부당 청구하고, 환자들에게는 허위 입원확인서를 발급해주는 조건으로 일당 4∼12만원의 입원비를 편취\r\n환자들은 실제 입원한 사실이 전혀 없음에도 허위 입원확인서를 발급받거나, 입원기간을 부풀려서 허위 청구하는 방법으로 31개 보험회사로부터 23.1억의 보험금을 부당수령',
      CPT_WASH_ID: '00000000000000000154',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '23.1',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_70',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '관절질환 치료 전문병원의 허위입원 보험사기 적발',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '서울 OOO병원은 의사와 사무장이 병원수익금을 분배하기로 약속하고 설립한 사무장병원으로\r\n고액의 보험금 수령이 가능한 관절질환 치료를 명목으로 브로커(사무장), 설계사 등이 개입하여 허위입원을 조장하고 진단서 등을 조작\r\n사무장 개인사무실을 입원실인 것처럼 허위병상 운영을 하거나, 수술횟수 및 입원기간을 늘리는 수법으로 허위진단서를 발급하고, 보험상품의 특성에 맞게 질병사고를 상해사고로 조작 청구하여 보험금을 수령',
      CPT_WASH_ID: '00000000000000000155',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_71',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 가입 부적격 사유를 숨기고 보험금 청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '09',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'A(‘70년생, 여)씨는 자녀 B(‘96년생, 남) 및 C(‘97년생, 남)군과 함께 ’10.4.21. 미국 영주권을 취득하였으나 이를 알리지 않고 ‘10.7.20., ’11.7.15. 및 \'12.8.3. 반복적으로 해외여행보험 가입 후 다수의 부당청구로 총 6,560천원의 보험금을 수령\r\nA씨는 \'10.11.23., ‘10.12.1., ’11.11.2., ‘12.8.9. 및 \'12.8.13. ‘두통’ 및 ‘생리통’ 등으로 거주지인 LA 소재 병원치료 후 총 2,203천원의 보험금을 부당 수령\r\n형 B군은 ‘11.1.21., ’11.8.8., ‘12.3.28., ‘12.7.28. 및 ‘12.11.1. ‘감기’, ‘발목 및 치아 통증’ 등을 이유로 치료 후 총 2,106천원의 보험금을 수령\r\n동생 C군도 \'10.9.3, ‘11.1.31, ’11.10.25., ‘12.7.17., ’12.10.25. 및 ‘12.11.1. ‘피부발진’, ‘발목 및 ‘치아 통증’ 등을 이유로 병원치료 후 총 2,251천원의 보험금을 수령',
      CPT_WASH_ID: '00000000000000000156',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험 부적격자가 부적격 사유를 숨기고 보험 가입 후 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_72',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 가입 부적격 사유를 숨기고 보험금 청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'D(‘85년생, 여)씨는 ’98.10.12. 미국 영주권 취득 후 해외에서 장기간 거주하고 있으나, 이를 알리지 않고 국내 주소지를 기재하여 ‘09.3.9. 해외여행보험 가입 후 총 2,622천원의 보험금을 부당 수령\r\nD씨는 일상생활 중 발생한 ‘땀띠’ 및 ‘메스꺼움’ 등을 이유로 \'09.6.8. 및 ‘10.2.23. 미국 소재 병원치료 후 총 2,116천원의 보험금을 수령\r\n또한 ‘10.3.15. 아버지를 계약자로 하여 동 보험에 재가입 후  ’10.6.11. ‘벌레 물림’을 이유로 506천원의 보험금을 수령',
      CPT_WASH_ID: '00000000000000000157',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험 부적격자가 부적격 사유를 숨기고 보험 가입 후 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_73',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 가입 부적격 사유를 숨기고 보험금 청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'E(‘66년생, 여)씨는 ’03.11.14. 미국 영주권을 취득하였으나, 해외 거주사실을 알리지 않고 ‘10.3.5. 배우자를 계약자로 하여 해외여행보험 가입 후 총 3,157천원의 보험금을 부당 수령\r\nE씨는 ‘10.8.9., ’10.10.18., ‘10.10.21., ’10.12.10. ‘복통’ 및 ‘급성 인두염’ 등을 이유로 LA소재 병원 치료 후 보험금을 청구(총1,982천원 청구)하였으나 진료비 과다 청구로 삭감되어 최종 1,813천원의 보험금을 수령\r\n이후 E씨는 ‘11.4.14. 동 보험에 재가입하고 ’11.5.16., ‘11.7.17., ’11.8.2. ‘두통’ 및 ‘발목염좌’ 등으로 한의원 등에서 치료받았으나 진료비 과다 청구(총2,028천원 청구)로 삭감되어 최종 1,356천원의 보험금을 수령',
      CPT_WASH_ID: '00000000000000000158',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '보험 부적격자가 부적격 사유를 숨기고 보험 가입 후 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_80',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '17',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '렌터비 부당청구 적발 사례(대여기간 부풀리기)',
      BZC_DSC_NM: '자동차정비업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '◯◯렌터카는 차량번호 xx허xxxx인 차량을 실제로는 ‘10.7.15.～7.22.(8일) 동안 대여하였으나, ‘10.7.15.～7.28.(14일) 동안 대여한 것으로 임대차계약서를 변조(수정액 사용)하여 A손해보험회사에 렌트비를 청구(FAX송신)하여 6일치 렌트비 320만원을 부당 수령',
      CPT_WASH_ID: '00000000000000000159',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '문서 위조를 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.032',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_81',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '17',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '렌터비 부당청구 적발 사례( 미사용 렌트비 허위 청구)',
      BZC_DSC_NM: '자동차정비업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '◯◯렌트카는 임차인(보험사고 피해자) 양○○와 공모하여 실제로는 차량번호 xx허xxxx인 차량을 대여하지 않았으면서도 5일간 대여한 것으로 임대차계약서류를 위조하여, M손해보험회사로부터 5일치 렌트비 318만원을 부당 수령하고 임차인에게 170만원을 배분',
      CPT_WASH_ID: '00000000000000000160',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '문서 위조를 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.032',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_82',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '17',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '렌터비 부당청구 적발 사례(고가 차량을 렌트한 것으로 청구)',
      BZC_DSC_NM: '자동차정비업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '◯◯렌트카는 임차인(보험사고 피해자) 유○○와 공모하여  ‘11.12.22.~’11.12.28. 동안 실제로는 “K7” 차량을 대여하였으나 “BMW750” 차량을 대여한 것으로 임대차계약서를 위조하여 L손해보험사에 6일간 렌트비 215만원을 부당 수령',
      CPT_WASH_ID: '00000000000000000161',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '문서 위조를 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.032',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_86',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '04',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 실종신고로 사망보험금 편취',
      BZC_DSC_NM: '귀금속 등 현금집중사업',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '이○○는 모텔을 운영하며 고액의 대출을 받고 이자를 지급하지 못하여 경매에 넘어가게 되자 모텔 종업원으로 근무하던 최○○와 내연관계를 맺은 후 최○○를 피보험자로 하고 이○○를 보험수익자로 하는 13건의 생명보험계약을 체결\r\n다수보험 가입 직후 이○○는 최○○이 가출하였다며 파출소에 실종신고를 하고 5년이 경과한 시점에 실종선고심판이 확정되자 24억원의 사망보험금을 청구하였으나 미수에 그침\r\n법원은 이○○가 편취하려 한 보험금의 액수가 24억원에 이르는 점, 오랜 기간에 걸쳐 계획적으로 저지른 범행으로 죄질이 매우 불량한 점, 민사소송절차에서 제1심판결에 항소하여 다투는 등 보험금을 편취하려는 시도를 중단하지 않고 있는 점 등을 참작하여 징역 3년 선고',
      CPT_WASH_ID: '00000000000000000162',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 허위 실종 신고를 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '24',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_15',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위․과다 입원을 통한 일가족 보험사기',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '범죄조직 및 테러단체',
      CPT_WASH_CNTN: '[사건개요] \r\n전직 설계사이자 조직폭력배인 A모씨 등 일가족 11명은 246개 보험계약을 체결 후, 10여년 동안 고혈압․위궤양 등 입원치료가 불필요한 경미한 질병으로 허위․과다 입원 등의 수법으로 26개 보험사로부터 17억원의 보험금을 편취 (‘14.4월 검찰 송치)\r\n\r\n[특이사항] \r\n일가족 대부분이 무직임에도 개인당 최소 59~192만원의 보험료를 매월 납입하는 등 편취한 보험금의 일부를 보험료로 납부하는 등 보험사기의 악순환을 보임',
      CPT_WASH_ID: '00000000000000000163',
      CUS_CHR_C: '05',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '다수 혹은 고액 보험 가입 후 허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '17',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_16',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '무허가 병상 추가 설치를 통한 건강․민영보험금 편취',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n○○병원장 A모씨는 허가받지 않은 60개의 병상을 추가로 설치하여 B모씨 등 환자 60여명의 장기·반복 입원을 묵과 혹은 방조하는 수법으로,환자들이 23억 3천만원의 보험금을 편취하는데 도움을 주었고, 병원은 46억 5천만원의 건강보험금을 편취 (병원장 : ‘14.7월 검찰송치, 환자 : ’14.9월 검찰 송치)\r\n\r\n[특이사항] \r\n○○병원은 환자를 소개해준 택시 기사 등에게 환자의 입원일수에 따라 3~5만원씩 소개비를 지급하여 환자들을 유치',
      CPT_WASH_ID: '00000000000000000164',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '23.3',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_19',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: 'TM',
      CPT_WASH_TI_NM: '진단서 위조를 통한 보험금 부당 수령',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n보험설계사 A모씨는 컴퓨터로 본인이 모집한 고객들 명의의 진단서 70여장을 위조하여 2억 3천만원의 보험금을 편취(‘14.1월 검찰 송치)\r\n\r\n[특이사항] \r\nA모씨는 본인 명의 진단서를 위조하여 계속 보험금을 청구하면 범행 사실이 발각 될 것을 우려하여 고객들 명의로 진단서를 위조하는 치밀함을 보임',
      CPT_WASH_ID: '00000000000000000165',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위진단을 통한 보험금 청구',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '2.3',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '2',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_126',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '수술횟수 부풀리기 조장',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '특정 보험설계사에 의해 모집된 10여명의 보험가입자가 특정 병원에서 집중적으로 “동일한 특정 수술”을 수회 반복적으로 실시*한 것으로 의료기록 등을 조작하여,\r\n   * 동 수술은 의학적으로 단기간 내에 반복적으로 시행하지 않는 것으로 확인\r\n- 이른바 수술횟수 부풀리기로 수술보험금을 편취한 사례',
      CPT_WASH_ID: '00000000000000000206',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '특정 보험설계사에 의해 모집된 가입자가 수술횟수를 부풀릴 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_127',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '경영난에 처한 병원 약점을 이용, 허위 입원·장해 조장',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '특정 보험설계사가 경영난에 처한 병원의 약점을 이용하여 보험가입자를 병원에 알선해 주고, 보험가입자에게 허위 입원·장해 진단서를 발급받도록 하여 보험금을 편취하는 사례\r\n- 금감원 IFAS 분석을 통해 ‘원격지 거주자 장해 진단비율’이 상대적으로 높은 병원임을 확인한 후,\r\n- 동 병원에서 치료받은 환자*의 보험금 청구 관련자료 등을 분석하여 우선 혐의 대상건으로 선정\r\n    * 동일한 특정 보험설계사에 의해 모집된 보험가입자',
      CPT_WASH_ID: '00000000000000000207',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '특정 보험설계사에 의해 모집된 가입자가 동일한 병원에서 허위 진단을 받을 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_128',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '2개 이상 병원 동시 입원',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '특정 지역의 보험설계사들이 ‘경미한 질병’으로 장기 입원하는 방법으로 입원보험금을 편취하는 사례\r\n- IFAS 연계분석을 통해 다수(7∼17건)의 보험계약에 가입한 특정 지역의 보험설계사 중,\r\n- ‘2개 이상 병원에 동시 입원’하고, ‘입원보험금이 일정금액* 이상’인 보험설계사를 우선 혐의 대상으로 선정\r\n      * (예시) 입원보험금 수령액 5천만원 이상 등',
      CPT_WASH_ID: '00000000000000000208',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '특정 보험설계사에 의해 모집된 가입자가 동일한 병원에 허위 진단을 받을 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_129',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '체형교정 사무장병원 운영을 이용한 보험사기',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\nA씨는 비의료인으로 ‘12년 5월부터 의사의 명의를 빌려 사무장 병원을 운영하면서 국민건강보험공단 등으로부터 122억 상당의 진료비 편취\r\n- 비수술 체형교정 전문병원으로 홍보하고 고가의 치료시스템(회당 15만원, 기본 30회)을 만든 후, 고가의 치료를 망설이는 환자들에게 개인적으로 가입된 실손의료보험으로 모두 보전 받을 수 있다고 유인한 후 환자들이 보험금을 편취할 수 있도록 허위 진료비 영수증을 발급(‘16.3월 검찰송치)\r\n\r\n[특이사항] \r\nA씨는 사설기관이 발행한 운동처방사 자격증을 보유한 무자격자 B씨 등을 운동 코디네이터로 고용한 후 물리치료사와 같은 복장으로 근무하게 하여 환자들을 상대로 운동치료 시행\r\n※ 보건복지부에 따르면 병원 내에서 이루어지는 물리치료 및 운동치료는 모두 의사와 의사의 지시·감독을 받는 물리치료사만 시행 가능',
      CPT_WASH_ID: '00000000000000000209',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '비의료인이 의사의 명의를 빌려 병원을 운영하면서 허위 진료비 영수증을 발급할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_130',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '장기간 입원 보험금을 편취한 보험사기 일가족',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\nA씨 등 일가족 4명은 입원 일당이 지급되는 보험에 집중 가입(44개, 월보험료 200만원)한 후 통원치료가 가능함에도 통증이 심한 것처럼 의사를 속여 장기입원하여 ‘08년부터 5년 동안 약 7억원의 보험금을 편취  (‘16.3월 검찰송치)\r\n\r\n[특이사항] \r\nA씨 일가족은 한달 보험료로 200만원 이상을 납입하고 입원 하루당 70만원의 입원보험금을 수령할 수 있도록 보험계약을 설계한 후 장기간에 걸쳐 보험금을 편취',
      CPT_WASH_ID: '00000000000000000210',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '통증이 심한 것처럼 의사를 속여 장기 입원할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_131',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 발급된 장해진단서로 보험금 편취',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n의사 A씨, 브로커(2명), 피보험자(37명)가 공모 후 피보험자들은 의사 A씨가 발급해준 허위장해진단서로 17억원 상당의 장해보험금 편취 (‘16.4월 검찰송치)\r\n\r\n[특이사항] \r\n피보험자들은 고액의 보험금을 편취하기 위해 1개월내 3개 이상의 보험에 가입하고, \r\n- 브로커들은 의사 A씨를 소개해준 대가로 피보험자들에게 장해 진단 보험금의 약 30%를 수수료로 받아 이중 일부를 의사 A씨에게 전달',
      CPT_WASH_ID: '00000000000000000211',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '의사가 허위장해진단서를 발급하여 보험금을 편취할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_135',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 작성한 렌트 차량 임대차 계약서로 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\nA렌트업체 등 2개 업체는 교통사고 피해자에게 차량을 대여한 사실이 없음에도 허위 렌트 계약서를 작성한 후 렌트 기간을 실제보다 과장하여 보험금을 청구하는 수법으로 4천 5백만원을 편취 (‘16.3월 검찰송치)\r\n\r\n[특이사항] \r\nA렌트업체 등은 보험사가 다른 보험사의 렌트비 지급내용을 확인할 수 없고 서류심사만으로 차량 렌트비를 지급한다는 점을 악용',
      CPT_WASH_ID: '00000000000000000212',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위 렌트 계약서를 작성하여 보험금을 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.45',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_136',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '17',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '차량 수리비를 과다·허위 청구하여 보험금 편취',
      BZC_DSC_NM: '자동차정비업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n甲특장업체 대표 A씨는 수리비 부담 없이 수리해주겠다고 사고 차량의 차주를 유인한 후 차주와 공모하여\r\n- 교환하지 않은 부품을 교환하거나 재고 또는 중고부품을 사용하고 신품으로 교환한 것처럼 보험사에 수리비를 과다 청구하는 방법으로 1억 1천만원을 편취 (‘16.1월 검찰송치)\r\n\r\n[특이사항] \r\n甲특장업체 관리이사 B씨는 회사 대표 A씨와 공모 후 B씨 본인 명의로 페이퍼컴퍼니 乙상사를 차리고 甲특장업체에 허위 부품납입청구서를 발급하고 甲특장업체는 상기 서류로 보험회사에 수리비를 청구',
      CPT_WASH_ID: '00000000000000000213',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위 부품납입 청구서를 발급하여 수리비를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.45',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 보험료 영수증 및 보험증권을 이용한 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 310억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000267',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.7억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사의 개인 수금 보험료 유용',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 311억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000268',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.06억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사의 개인 수금 보험료 유용',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 312억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000269',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.02억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사의 개인 수금 보험료 유용',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 313억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000270',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.02억원',
      PYM_CHAN_C: '1',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 고객 인적사항의 도용을 통한 고객 보험료 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 314억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000271',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '0.15억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 고객 인적사항의 도용을 통한 고객 보험료 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 315억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000272',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '0.1억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 고객 인적사항의 도용을 통한 고객 보험료 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 316억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000273',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '0.1억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: 'TM',
      CPT_WASH_TI_NM: '보험 고객 인적사항의 도용을 통한 고객 보험료 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 317억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000274',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '0.01억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '2',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 고객 인적사항의 도용을 통한 고객 보험료 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 318억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000275',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '0.0095억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '법인 자금 횡령 후 문서 위조를 통한 횡령 사실 은폐',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 319억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000276',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '30억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_115',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '간호조무사·보험설계사·보험가입자 등이 공모하여 보험금 편취',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n간호조무사, 보험설계사, 보험가입자 등이 공모하여 실제 입원 등 치료사실이 없음에도 간호조무사가 허위로 발급한 진단서, 입·퇴원확인서 등을 근거로 보험회사로부터 1억 1천만원을 편취\r\n- 보험설계사가 간호조무사에게 SNS를 통해 보험가입자의 인적사항, 병명을 보내주면, 간호조무사가 임의로 의사의 ID를 도용하여 전자차트프로그램에 접속하여 해당 병원 명의의 허위 서류를 발급 (2015.11월 검찰송치)\r\n\r\n[특이사항] \r\n보험설계사는 보험 가입자들에게 보험금을 수령케 한 대가로 보험가입을 유도하여 보험회사로부터 수당을 지급받았고, 간호 조무사는 허위로 서류를 발급해준 대가로 2,800만원 상당의 리베이트를 받음',
      CPT_WASH_ID: '00000000000000000199',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '병원의 허위 서류 발급을 통하여 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1.1',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_116',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '기초생활수급자 월 160만원 보험료 납부하며 3억원 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '[사건개요] \r\n기초생활수급자 A씨는 1개월 동안 입원 1일당 최고 73만원을 수령할 수 있는 보험을 9개 보험회사에 가입한 후 질병 등의 정도를 과장하거나 허위통증을 호소하는 방법으로 \r\n- 장기 입원이 가능한 12개 병원에 952일간 입원하여 보험회사로부터 3.2억원의 보험금을 편취 (2015.7월 검찰송치)\r\n\r\n[특이사항] \r\nA씨는 억대의 보험금 등을 타인 명의 계좌로 수령하면서 재산이 없고 병으로 경제활동을 할 수 없는 것처럼 가장하여 기초생활 수급자로 선정된 후 5천 7백만원의 기초생활수급비를 부당하게 수령',
      CPT_WASH_ID: '00000000000000000200',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '질병의 과장 등을 통한 장기입원으로 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '3.2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_117',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '병원기록을 조작하여 성형수술비 등을 실손보험금으로 편취',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n비의료인 A씨 등 2명은 속칭 ‘사무장병원*’을 개설하고 병원 운영비용을 충당하기 위해 보험설계사 등을 통해 환자를 유치 후 입원치료가 불필요한 환자들에게 허위 진단서, 진료기록부, 입퇴원확인서를 발급\r\n  * 비의료인인 사무장의 의료기관 개설은 의료법 제33조②항에 의한 불법행위\r\n- 환자 130여명은 허위 병원서류를 근거로 보험회사로부터 7억원 상당의 보험금을 편취하였으며, 사무장병원은 국민건강보험공단 요양급여 명목으로 6억 3천만원 상당을 편취 (2015.9월 검찰송치)\r\n\r\n[특이사항] \r\n보험설계사는 "성형수술이나 피부관리 비용을 실손보험금으로 지급받을 수 있게 해주겠다"는 말로 고객을 유인하여 병원을 소개하고 병원으로부터 소개비를 수령\r\n- 환자들은 상기 병원에서 직접 운영하는 피부관리실에서 ‘쌍커풀 수술, 피부관리 등’을 받은 후 병원에서 ‘요추, 경추 염좌 등’의 병명으로 발급해준 허위 병원서류를 바탕으로 보험금을 편취',
      CPT_WASH_ID: '00000000000000000201',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '질병의 과장 등을 통한 장기입원으로 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '6.3',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '01',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_118',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '레이싱중 발생한 사고를 일반사고로 위장하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n고가의 레이싱용 차량을 보유한 A씨 등 카레이싱 동호회 회원 9명은 자동차 경기장에서 사고가 발생한 차량을 견인기사와 공모한 후,  \r\n- 인적이 드문 일반 도로로 견인한 뒤 가드레일 등을 받아 사고가 발생한 것으로 위장하여 수리비 1.2억원을 편취 (2015.5월 검찰송치)\r\n\r\n[특이사항] \r\nA씨 등은 경기장에서의 사고와 일반도로에서 발생한 교통사고가 구분하기 어렵다는 점을 노려 최대 수천만원에 달하는 수리비를 충당\r\n ※ 자동차 경기장에서의 사고는 일반 자동차 사고에 비하여 사고발생 개연성이 높으며 손해 규모가 크기 때문에 차량을 경기용으로 사용 중 발생한 손해는 보상하지 아니함',
      CPT_WASH_ID: '00000000000000000202',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '사고 조사가 곤란함을 이용하여 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1.2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '01',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_120',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '외제차량을 고의로 침수시켜 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\nA씨 등 4명은 고가의 외제차를 침수시켜 자차보험금을 편취할 것을 모의하여 각자의 역할을 정한 후, 중고자동차 상사에서 고가의 외제차 1대를 할부로 구입하고 \r\n- A씨는 펜션 앞 하천에 고의로 차량을 침수시키고 보험회사로부터 43백만원 상당의 보험금 편취 (2015.8월 검찰송치)\r\n\r\n[특이사항] \r\nA씨 등은 외제차량의 자차보험 가액이 시세보다 높게 책정된다는 점을 악용하여 범행을 공모',
      CPT_WASH_ID: '00000000000000000203',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '고가의 차량을 이용하여 고의 사고를 유발 후 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1.2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '01',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_121',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '17',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '오토바이 허위·과장 수리비 견적서를 이용한 보험금 편취',
      BZC_DSC_NM: '자동차정비업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '[사건개요] \r\n오토바이 정비업체 대표인 A씨 등 30명은 사고 오토바이를 수리하면서 수리나 교환이 필요하지 않은 부속품을 수리비 견적서에 포함시켜 수리가격을 부풀리거나,\r\n- 사고 오토바이 수리기간 동안 다른 오토바이를 대여하지 않았음에도 허위 임대차 계약서를 작성하여 렌트비를 수령하는 등 6.3억원 상당의 보험금을 편취 (2015.10월 검찰송치)\r\n\r\n[특이사항] \r\nA씨 등은 오토바이 동호회 사무실 임대료 등을 지원하면서 오토바이를 소유한 동호회 회원들을 관리하였고 회원들의 고가 수입 오토바이 및 차량, 고위(위장)사고 유발 차량 등을 대상으로 허위·과다 수리하는 방법으로 보험금을 편취',
      CPT_WASH_ID: '00000000000000000204',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '허위·과다하게 수리하여 보험료를 청구할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '1.2',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '금감원 보도_125',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '단기간 다수보험 계약 후, 장기 입원 조장',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '특정 보험설계사에 의해 모집된 10여명의 보험가입자가 단기간에 걸쳐 다수(6∼17건)의 보험계약을 체결하고,\r\n- 동 보험가입자가 모두 “동일한 특정 병명”으로 동일 병원에 장기 입원하는 사례',
      CPT_WASH_ID: '00000000000000000205',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '특정 보험설계사에 의해 모집된 가입자가 동일한 병원에서 동일한 병명으로 장기 입원할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2014.08.28)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '국민은행 본점 부문검사 결과(국민주택채권의 횡령)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 292억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000249',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '111억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2014.08.28)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '국민은행 본점 부문검사 결과(동경지점 부당대출)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 293억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000250',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '5,390억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2014.04.13)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '법인인감증명서 도용 및 문서위조 등에 의한 금융사고',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 294억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000251',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '06',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '30억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '주금가장납입 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2013.07.17)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '신한은행 종합검사 결과(여신심사 소홀 등으로 인한 부실 초래)',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 295억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000252',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '3,080억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2013.07.17)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '2',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '신한은행 종합검사 결과(파생상품 회계 부당처리)',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 296억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000253',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '33,385억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2013.03.12)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '05',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '의조적인 담보 감정가액의 과다산정',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 297억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000254',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '47억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2012.09.26)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '대출서류 임의변경',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 299억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000256',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2012.09.26)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '지급보증서 위조',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 300억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000257',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2012.09.26)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도���료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '표지어흠 위,변조',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 301억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000258',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2012.09.26)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '고객예금 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 302억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000259',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2010.12.29)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '외환은행 금융사고',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 303억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000260',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '730억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2013.03.12)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '위조된 표지어음 담보 대출',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 298억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000255',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '48억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료 (2010.10.06)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '경남은행 금융사고 - 허위지급보증 및 대출채권양수 계약 부당 체결',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 304억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000261',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '06',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '3,440억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '주금가장납입 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '실명확인 위반 및 임의 계좌 해지',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 305억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000262',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.06억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '상환된 견질어음 할인 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 306억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000263',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.1억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '타인 예금을 담보로 한 부당대출',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 307억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000264',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '부당담보대출',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 308억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000265',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.4억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도자료_금융사고 예방 매뉴얼 사례 (2005.09)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 보험료 영수증 및 보험증권을 이용한 횡령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 309억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000266',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.1억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_11',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '품질보증서 허위발급',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 392억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000349',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.0182억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_12',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '품질보증서 위・변조를 통한 허위청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 393억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000350',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.0182억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_13',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '사무장이 의료기관을 개설하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 394억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000351',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '10.1억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_14',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '사무장 병원의 허위진단을 통한 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 395억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000352',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '30억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_15',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위․과다 입원을 통한 일가족 보험사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 396억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000353',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '17억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_16',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '무허가 병상 추가 설치를 통한 건강․민영보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 397억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000354',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '23.3억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_19',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: 'TM',
      CPT_WASH_TI_NM: '진단서 위조를 통한 보험금 부당 수령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 398억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000355',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '2.3억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '2',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_20',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '장해를 허위로 꾸며 장해보험금 부당 청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 399억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000356',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1.3억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_21',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자동차 허위도난 신고를 통한 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 400억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000357',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.41억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_22',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '차량 고의 파손을 통한 차량수리비 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 401억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000358',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '2.4억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_27',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '일가족이 다수의 보험에 가입 후 허위진단을 통한 보험금 수령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 402억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000359',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '7.4억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_28',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '일가족이 다수의 보험에 가입 후 허위진단을 통한 보험금 수령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 403억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000360',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '9.1억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_32',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '합의금 과다 편취를 위한 단기 입․통원치료 반복',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 404억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000361',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '7.2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_36',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '구식 중고차, 고급튜닝 등 피해과장',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 405억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000362',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.7억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_38',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '병원 사무장·환자 공모를 통한 건강․민영보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 406억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000363',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1.7억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_39',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '장기·반복 입원을 통한 일가족 보험사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 407억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000364',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '5.7억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_42',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '이륜차 렌트업자의 계약서 조작',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 408억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000365',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.66억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_43',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '불법 수집한 고객정보를 활용한 보험사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 409억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000366',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1.3억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_04',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험대리점을 운영하면서 다수보험 가입 후 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 385억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000342',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_05',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '입원이 필요 없는 경미한 질병으로 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 386억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000343',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_06',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '본인 및 가족을 보험에 가입시킨 후 허위치료를 통하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 387억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000344',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_07',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 진료확인서 등을 발급받아 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 388억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000345',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_08',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '부품 거래명세표 위․변조',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 389억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000346',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_09',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '간이영수증 등으로 부품내역 허위기재',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 390억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000347',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.14억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_10',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '부품단가를 부풀려 청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 391억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000348',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.39억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_46',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사가 본인과 가족을 동원하여 허위․과장 입원',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 410억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000367',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '3.14억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_47',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사가 지인과 공모하여 허위로 무릎수술 유도',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 411억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000368',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.51억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_48',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '○○ 가축보험 담당자가 가축주와 공모하여 사고 조작',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 412억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000369',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '5.5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_50',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '레이싱 중 발생한 사고를 일반사고로 조작',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 413억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000370',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1.4억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_52',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '렌트카 업체가 대여기간 등을 조작하는 수법으로 사기를 주도',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 414억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000371',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '3.1억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_53',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '경미한 접촉사고 발생 후, 피해를 과장하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 415억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000372',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_56',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자동차보험 관련 사기행위(피해자 끼워넣기형)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 416억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000373',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_57',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자동차보험 관련 사기행위(허위 교통사고 신고형)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 417억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000374',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_58',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '생명․장기보험 관련 사기행위(기존질병 은폐형)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 418억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000375',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_60',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '생명․장기보험 관련 사기행위(장기 과다입원형)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 419억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000376',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_61',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '생명․장기보험 관련 사기행위(허위진단서 발급형)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 420억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000377',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_62',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 관련 지식을 악용하여 고의적 사고 유발을 통한 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 421억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000378',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.242억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_65',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 입원',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 422억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000379',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1.6억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_66',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '일가족 보험사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 423억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000380',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '2.3억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_67',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '브로커 허위입원 알선',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 424억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000381',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_68',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '의사의 불법행위',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 425억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000382',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '10억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_69',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '진료행위 없이 숙식만 제공하는 모텔형 병원 보험사기 적발',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 426억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000383',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '23.1억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_70',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '관절질환 치료 전문병원의 허위입원 보험사기 적발',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 427억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000384',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_71',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 가입 부적격 사유를 숨기고 보험금 청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 428억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000385',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_72',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 가입 부적격 사유를 숨기고 보험금 청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 429억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000386',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_73',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험 가입 부적격 사유를 숨기고 보험금 청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 430억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000387',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_80',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '렌터비 부당청구 적발 사례(대여기간 부풀리기)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 431억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000388',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.032억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_81',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '렌터비 부당청구 적발 사례( 미사용 렌트비 허위 청구)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 432억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000389',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.032억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_82',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '렌터비 부당청구 적발 사례(고가 차량을 렌트한 것으로 청구)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 433억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000390',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.032억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_86',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 실종신고로 사망보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 434억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000391',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '24억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_88',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '의료소비자생활협동조합 부속 의료기관',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 435억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000392',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_89',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '1개 의원급 의료기관에서 가짜환자 등 455명 무더기 적발',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 436억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000393',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_90',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '사무장 부부가 운영하는 한의원',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 437억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000394',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_91',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '불법 낙태와 무자격 성형수술까지',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 438억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000395',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_92',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '지자체배상책임보험금 수령 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 439억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000396',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_93',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '도급업자배상책임보험금 수령 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 440억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000397',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1.5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_98',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사가 인력사무소 소속 근로자를 이용하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 441억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000398',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '4.9억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_99',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '전·현직 보험설계사가 가족·지인과 공모하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 442억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000399',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '35억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_100',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험설계사가 사망진단서 위조로 가족의 사망보험금 부당청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 443억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000400',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '6.2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_102',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '의사와 보험사기 브로커가 공모한 허위장해 보험사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 444억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000401',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.6억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_103',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '불법 사무장병원 운영자와 허위환자가 공모한 보험사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 445억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000402',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.6억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_105',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 렌트계약서를 이용한 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 446억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000403',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.6억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_106',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '차량을 담보물로 제공 후 허위 도난 신고하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 447억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000404',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.6억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_107',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '高價 외제차량을 이용한 편취금액 확대사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 448억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000405',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.6억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_108',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '동일 차량을 상습적으로 이용한 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 449억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000406',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.6억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_109',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '동일 차량을 여러 업체에서 반복적으로 이용한 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 450억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000407',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.6억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_110',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '암환자에게 고주파온열치료 등 치료횟수 부풀려 청구',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 451억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000408',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '52억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_111',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '고가의 렌즈삽입술을 하면서 수술횟수 및 병명을 조작',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 452억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000409',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '52억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_112',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '성형수술비를 실손의료보험으로 보장되도록 진료내용 조작',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 453억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000410',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '52억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_113',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '비의료시설 이용 후 의료기관에서 치료한 것으로 진료비영수증 발급',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 454억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000411',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '52억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_114',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '전국 20여 곳 병원을 투어하며 반복 입원하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 455억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000412',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '8.5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_115',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '간호조무사·보험설계사·보험가입자 등이 공모하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 456억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000413',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1.1억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_116',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '기초생활수급자 월 160만원 보험료 납부하며 3억원 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 457억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000414',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '3.2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_120',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '외제차량을 고의로 침수시켜 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 460억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000417',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1.2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_121',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '오토바이 허위·과장 수리비 견적서를 이용한 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 461억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000418',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1.2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_125',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '단기간 다수보험 계약 후, 장기 입원 조장',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 462억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000419',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_126',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '수술횟수 부풀리기 조장',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 463억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000420',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_117',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '병원기록을 조작하여 성형수술비 등을 실손보험금으로 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 458억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000415',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '6.3억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_118',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '레이싱중 발생한 사고를 일반사고로 위장하여 보험금 편취',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 459억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000416',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1.2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_127',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '경영난에 처한 병원 약점을 이용, 허위 입원·장해 조장',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 464억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000421',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_128',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '2개 이상 병원 동시 입원',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 465억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000422',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '금감원 보도_129',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '금감원 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '체형교정 사무장병원 운영을 이용한 보험사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 466억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000423',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '3',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '3'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '검찰청 보도자료(2012.01.25)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '해외투자를 가장, 회사건물 물려주려 해외 페이퍼컴퍼니를 통한 자금세탁 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 289억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000246',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '300억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료 (2011.11.06)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '09',
      IV_C: '2',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '폐구리 위장 거래 관련 조세포탈 사례',
      BZC_DSC_NM: '무기업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 290억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000247',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '거액 입금 후 당일 또는 익일 중 인출',
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '06',
      TR_SCL_AM: '684억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '검찰청 보도자료(2015.2.05)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '12',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '깡통주택을 이용한 부동산 사기단 단속',
      BZC_DSC_NM: '부동산중개업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '이미 시세를 훨씬 초과하는 액수의 저당권이 설정되어 있어 담보가치가 거의 없고 대출이자 연체로 경매 위기에 있는 속칭 ‘깡통주택’을 이용하여 금융기관의 대출금과 서민의 소액보증금을 편취한 민생침해사범에 대한 수사를 실시하여,\r\n- 노숙인 등 속칭 바지를 내세워 ‘깡통주택’을 구입한 다음, 매매대금을 부풀린 계약서 및 위조 재직증명서 등을 이용하여 은행으로부터 대출금을 편취하고, 다시 영세한 서민들로부터 소액임차보증금을 편취한 부동산 사기조직을 적발하고,\r\n- 또한, 이에 가담한 부동산중개업자, 금품 및 향응을 제공받고 대출과 등기를 도와 준 금융기관 직원, 신용정보회사 직원 및 법무사 등을 함께 기소하였음\r\n[수사/조사 결과]\r\n부동산 브로커, 바지 모집인, 대출브로커, 법무사 등 총 71명을 인지하여 9명을 구속기소하고, 53명을 불구속 기소, 9명을 기소중지하였음\r\n※ 전체 피해금액 18억 2,180만원 (대출금 10억 3,530만원, 전세보증금 7억 8,650만원)',
      CPT_WASH_ID: '00000000000000000081',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 신용정보회사 직원 및 금융기관 대출 직원 등 전문적 지식을 이용하여 범행에 가담할 위험\r\n- 소액임차보증금 우선변제권 악용하여 일반 소액임차인이 피해를 볼 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '18',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료\r\n(2011.11.06)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '09',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '폐구리 위장 거래 관련 조세포탈 사례',
      BZC_DSC_NM: '무기업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '폐구리 실거래자인 L○○,O○○ 등은 공모하여 2012.11.26.~ 2013.12. 하순경 폐구리 거래 관련하여 ‘폭탄업자’D△△ 등 3명을 이용 공급가액 합계 684억 16,799,710원 규모의 허위세금계산서를 발급. 폭탄업체의 성격상 세무조사를 받게 될 위험성이 크므로 제련업체는 폭탄업체로부터 세금계산서를 받지 않고, 상위 간판업체로부터 매입자료 확보. 제련업체 등에 폐구리를 무자료로 공급하는 배후 수집상 대신 폭탄업체 명의로 허위세금계산서를 발급해주고, 발행금액의 3% ~ 4%에 달하는 수수료를 취득하며 조세 포탈을 조장함. 폭탄업자는 입금된 돈을 전액 현금으로 출금한 후 일정한 수수료를 제외한 나머지 돈 전부를 폐구리 수집상에게 전달해주고, 자금추적을 불가능하게 하여 폐구리 수집상이 안정되게 조세를 포탈할 수 있도록 해줌 .\r\n위 L○○,O○○ 등은 공모하여 2013.12.하순경 폭력배 3명을 동원하여 수사기관에 자수하려는 위 D△△을 구타한 후 관련 증거를 빼앗음.\r\n\r\n[조치사항]\r\n이 사건 범행을 통해 포탈된 세금 추징,환수',
      CPT_WASH_ID: '00000000000000000003',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '거액 입금 후 당일 또는 익일 중 인출',
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '무자료 판매 후 허위 계산서를 이용하여 자금을 받고, 전액 현금으로 인출하여 자금의 흐름을 은페하고 세금을 탈루할 위험',
      SUSPI_TRTP_C: '06',
      TR_SCL_AM: '684',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '검찰청 보도자료(2012.01.25)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '해외투자를 가장, 회사건물 물려주려 해외 페이퍼컴퍼니를 통한 자금세탁 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '트리스타 법인 대표 ooo은 편법상속을 위해 중국에 투자하는 것처럼 가장하여 건물을 담보로 300억원 담보 대출, 단순직접해외투자로 신고하여 미리 조세피난처인 홍콩에 설립해둔 6개의 페이퍼컴퍼니로 전액 송금하여 회사 돈을 횡령하고, 자금세탁을 거쳐 범죄수익 은닉.\r\n범행을 공모한 부동산 개발업자가 탈세플렌을 제시, 공인회계사 등 3명은 탈세 플랜을 검토하고 허위서류를 작성.\r\n[조치사항]\r\n회사 대표 구속 기소, 공인회계사들 각 불구속 기소, 부동산 개발업자는 도주하여 지명수배',
      CPT_WASH_ID: '00000000000000000068',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 조세피난처에 페이퍼컴퍼니를 설립하여 불법자금을 세탁한 후 은닉할 위험\r\n- 홍콩에서는 법인을 양도할 경우 증여세 등 세금이 부과되지 않는 점을 이용하여 재산국외도피할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '300',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '01',
      SOUR_DTL_CNTN: '검찰청 보도자료(2014.06.09)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '08',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '유망 중소기업 첨단기술 유출 사건 중 허위 발주서 보증으로 대출을 받은 사례',
      BZC_DSC_NM: '건설업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'ㄱ사의 HST 설계도면 1,551장을 퇴사시 반환하지 않고 보관한 A씨로부터 HST 설계도면 44장을 취득한 제조 및 설계회사 ㄷ사 대표 D씨와 연구소장 E씨는 HST 설계도면 44장을 이용하여 HST 45씨씨 개발 및 생산 자금을 마련하고자, 160억 상당의 HST 45씨씨 17,000대를 주문받은 것처럼 발주서를 변조하여 신용보증기금으로부터 10억 7천 9백만원 상당을 보증받고 은행으로부터 5억원을 대출받음\r\n[조치사항]\r\n관련자 5명 구속기소, 2명 불구속.기소. 5억원 전부를 회수.',
      CPT_WASH_ID: '00000000000000000069',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 허위 발주서 등을 통한 사기대출 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '5',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '검찰청 보도자료\r\n(2014.09.04)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '14',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '폐쇄등기부 이용, 전세계약서 위조 60억원대 작업대출 조직 적발',
      BZC_DSC_NM: '비은행 금융기관(은행 이외 제2금융권)',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '2012년 1월 경부터 2014년 1월 경까지 임대인과 대출신청자 사이에 전세계약을 체결한 사실이 없음에도 마치 전세계약을 체결하고 전세보증금을 지급한 것처럼 허위의 전세계약서를 작성하고, 대출신청자가 페이퍼컴퍼니에 근무하는 것처럼 허위의 재직증명서 등을 제출하는 방법으로 금융기관으로부터 120여회에 걸쳐 60억원 상당의 대출을 받아 사기.\r\n그 과정에서 부동산 소유자의 허락 없이 임대인 명의의 전세계약서를 작성하여 사문서위조 및 위조사문서행사. 또한 ○○시청 5급 사무관 승진 내정자, 7,500만원 대출사기에 관여, 고도의 도덕성이 요구되는 ○○캐피탈 대출상담사는 오히려 대출 신청자들과 조직원을 알선해주는 브로커 역할 담당.\r\n작업대출에 관련된 조직원이 11명,대출신청자가 120여 명,약 2년간 대출액이 총 60억원에 이르고 조직원이 대출액 중 약 60%의 수익을 취득한 사실 확인.\r\n\r\n[조치사항]\r\n작업대출 조직의 총책인 A를 구속기소하면서,A가 범죄수익금으로 구입한 A 명의의 아파트,가족 명의로 구입한 아파트,외제차 등 8억 원 상당의 재산을 찾아 내 추징보전 집행을 완료하는 등 불법수익을 적극 환수하였음.',
      CPT_WASH_ID: '00000000000000000075',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '06',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 주소제공만으로도 폐쇄등기부등본 발급이 가능한 점을 이용하여 이름, 주민등록번호 등의 개인정보가 유출될 위험\r\n-금융기관 내부직원이 연류되어 불법행위를 조장할 위험\r\n-부동산 담보대출 시 문서확인철자의 허점을 이용하여 대출사기가 발생할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '60',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '주금가장납입 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료(2014.08.21)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '05',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '“주식매각 과정에서 뒷돈 챙긴”한국 교직원 공제회 자회사 前 투자팀장 구속기소',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '09',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '감사원에서 수사의뢰한 한국교직원공제회의 자회사인 A社 前투자팀장 B○○의 업무상배임 사건을 수사.\r\nB○○가 4개의 비상장 법인 주식을 知人에게 저가에 매도한 후 되팔아 차익을 나누어 가진 혐의를 추가로 적발하였음. B○○는 뒷돈을 받은 사실을 숨기기 위해 공범 C○○가 취득한 이익금의 일부를 회계법인에 주식평가수수료 명목으로 송금하게 한 후 이를 다시 송금받음. OO특수법인의 자회사인 A社의 비상장주식매매를 사실상 투자팀장인 B○○이 단독으로 결정하고, 회사의 감독이 소홀한 구조적 문제를 이용함.\r\nA社가 투자한 비상장법인 주식을 실거래가격보다 낮은 가격에 매도한 후 그 차익을 나누어 갖는 등 비상장주식 매각 과정에서 회사에 10억원 상당의 손해를 가함.\r\n[조치사항]\r\nB○○을 특정경제 범죄가중처벌등에관한법률위반(배임) 등의 혐의로 구속 기소, 범행에 적극적으로 가담하여 이익을 나누어 가진 C○○ 등 3명을 불구속 기소하였음',
      CPT_WASH_ID: '00000000000000000076',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '교환거래',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 내부직원인 투자팀장이 회사의 허술환 감시체계를 이용하여 개인 이득을 취할 위험\r\n- 타인의 계좌를 이용함으로써 자금출처를 은닉할 위험',
      SUSPI_TRTP_C: '03',
      TR_SCL_AM: '10',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료(2015.2.02)',
      REL_FNC_CO_C: '06',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '14',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '고교동창생으로부터 거액을 받고 10억 원을 대출해 준 저축은행 여신팀장 등 대출비리 사범 적발',
      BZC_DSC_NM: '비은행 금융기관(은행 이외 제2금융권)',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '대출브로커를 통하여 고교동창생인 대출신청인으로부터 거액의 금품을 받고 허위 계약서를 담보로 10억 원을 대출해 준 (주)○○○○저축은행 여신팀장 등 대출 비리 관련자 4명을 적발하여 그 중 3명을 구속 기소하고,1명을 불구속 기소하였음',
      CPT_WASH_ID: '00000000000000000082',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 대출심사제도의 허점을 이용하여 불법대출할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '10',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '02',
      SOUR_DTL_CNTN: '검찰청 보도자료(2015.01.14)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '01',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '13',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '가짜 수출서류 보증 사기대출 사례',
      BZC_DSC_NM: '무역업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '2009.8.경∼2010.2.경 의류수출업체에 업체명의를 빌려주고, 마치 D 및 E업체가 수출한 것처럼 62만불(6억7천만 상당)의 허위의 수출면장 등의 서류를 만들어 무역보험공사의 보증을 받아 농협으로부터 3회에 걸쳐 합계 2억 3천만원을 대출 받아 사기.\r\n※카◯◯는 대출브로커로서, 유령업체대표들을 모집하여 허위실적서류를 작성하여 대출을 알선해 주고 대출금의 10%에서 30%상당을 지급받음. 총 10개 업체의 사기대출을 알선하고 합계 6,500만원을 수수.\r\n[조치사항]\r\n13개 유령업체 대표 10명 및 사기대출 알선브로커 3명 등 총 13명을 인지\r\n4명 구속기소,6명 불구속기소,3명 기소중지',
      CPT_WASH_ID: '00000000000000000083',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 허위 수출면장 등을 통한 사기대출 위험\r\n(유령업체 설립 -> 허위수출서류 작성 -> 세관 수출신고 -> 무보 보증신청 -> 금융기관 대출 -> 업체 폐업 -> 무보 대위변제)\r\n-담보없이 일정 수출실적 등으로 신용대출을 받을 수 있도록 운영되는 무역보험공사 등의 신용보증제도를 악용',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '2.3',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료(2015.1.13)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '12',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 감정을 통한 거액 대출사기에 가담한 감정평가사와 은행직원 적발',
      BZC_DSC_NM: '부동산중개업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '서울동부지검 형사5부(부장검사 김호경)는 부동산개발업자와 감정평가사 및 은행 직원이 공모하여 담보물에 대한 허위 감정을 바탕으로 금융기관에 대출을 신청하는 방법으로 15차례에 걸쳐 총 42억 9,000만원을 대출받은 사실을 확인하고, 감정평가사 ㄴ○○(48세) 및 금융기관 직원 ㄷ○○(44세)등 2명을 특경법위반(사기)죄로 구속 기소하고, 달아난 부동산 개발업자 ㄱ○○(55세)1명을 특경법위반(사기)죄로 지명수배 하였으며,ㄴ○○이 소속된 ㅁ 감정평가법인을 부동산가격공시및감정평가에관한법률 위반죄로 입건하여 불구속 기소하였음\r\n[수사/조사 결과]\r\n특경법위반(사기)죄로 그 중 2명을 구속 기소하고, 1명을 불구속 기소하였으며, 달아난 부동산개발업자를 지명수배',
      CPT_WASH_ID: '00000000000000000084',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 감정평가사 내지 금융기관 임직원 등 전문적 지식을 이용하여 범행에 가담할 위험\r\n- 담보대출 과정에서 담보물에 대한 심사제도의 허점을 이용하여 불법대출할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '42.9',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료\r\n(2014.05.08)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '15',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '사기대출 9000억원 등 그룹회장 및 경영진들의 대기업 비리 사건',
      BZC_DSC_NM: '해운업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'STX 조선해양(주)의 2008~2012 회계연도 결산시 5년간 합계 2조 3,000억대의 영업이익을 과대계상하여 회계분식, 허위 재무제표를 이용하여 2조 6,500억원 상당의 사기대출 및 회사채 부정발행, 회사자금 557억원 횡령, 계열사 자금 2,843억원 상당으로 개인회사를 부당지원 함.\r\n(사기대출 관련 - 2008.~2012. 회계연도 관련, STX 조선해양의 매출액 과대 계상, 매출원가 과소계상 수법으로 합계 2조3,264억원 상당의 이익을 과대계상하여 허위 재무제표 작성, 공시. OOO조선해양의 허위 재무제표를 이용하여 OO은행 등으로부터 대출 9,000억원(실피해액 5,514억원)(사기), 회사채 등 1조 7,500억원(실피해액 9,772억원) 상당 사기적부정거래.)\r\nOOO는 횡령한 회사자금 557억원을 대부분 개인부채 변제와 경영권 확보 등 개인적 이익을 위해 사용.\r\n[조치사항]\r\n그룹 회장 뿐만아니라 회계분식을 주도한 대표이사, CFO까지 모두 구속 기소\r\n[관련언론보도]\r\nhttp://www.newsis.com/ar_detail/view.html?ar_id=NISX20140508_0012903874&cID=10201&pID=10200',
      CPT_WASH_ID: '00000000000000000066',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 매출액 과대 계상, 매출원가과소계상 등 허위재무제표을 이용하여 사기대출할 위험\r\n',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '9000',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료(2014.2.11)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '14',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '새부안 새마을 금고 대출비리 사건 수사결과',
      BZC_DSC_NM: '비은행 금융기관(은행 이외 제2금융권)',
      TR_CHR_C: '08',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '새부안 새마을금고 이사장과 여신과장이 양식업자로부터 대출 편의를 부탁받고 부동산 담보 대출을 해주면서, 양식업자의 토지를 여러 사람의 이름으로 나눈 뒤 토지 별로 각각 대출신청을 하는 방법을 이용하여 19억원을 대출해주고, 각각 1천만원과 4,500만원을 수수한 사건을 수사하여, 이사장과 여신과장 2명을 구속기소하고, 대출담당 직원 및 양식업자 2명을 불구속기소하였음',
      CPT_WASH_ID: '00000000000000000067',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 대출심사제도의 허점을 이용하여 불법대출할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '19',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '검찰청 보도자료(2015.2.05)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '깡통주택을 이용한 부동산 사기단 단속',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 280억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000237',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '18억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료(2015.2.02)',
      REL_FNC_CO_C: '06',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '고교동창생으로부터 거액을 받고 10억 원을 대출해 준 저축은행 여신팀장 등 대출비리 사범 적발',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 281억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000238',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '10억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '02',
      SOUR_DTL_CNTN: '검찰청 보도자료(2015.01.14)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '01',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '가짜 수출서류 보증 사기대출 사례',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 282억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000239',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '2.3억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료(2015.1.13)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '허위 감정을 통한 거액 대출사기에 가담한 감정평가사와 은행직원 적발',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 283억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000240',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '42.9억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '검찰청 보도자료 (2014.09.04)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '폐쇄등기부 이용, 전세계약서 위조 60억원대 작업대출 조직 적발',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 284억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000241',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '06',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '60억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '주금가장납입 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료(2014.08.21)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '05',
      IV_C: '2',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '“주식매각 과정에서 뒷돈 챙긴”한국 교직원 공제회 자회사 前 투자팀장 구속기소',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 285억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000242',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '교환거래',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '03',
      TR_SCL_AM: '10억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '01',
      SOUR_DTL_CNTN: '검찰청 보도자료(2014.06.09)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: '08',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '유망 중소기업 첨단기술 유출 사건 중 허위 발주서 보증으로 대출을 받은 사례',
      BZC_DSC_NM: '건설업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 286억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000243',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료 (2014.05.08)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '사기대출 9000억원 등 그룹회장 및 경영진들의 대기업 비리 사건',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 287억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000244',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '9000억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '검찰청 보도자료(2014.2.11)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '검찰청 보도자료',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '새부안 새마을 금고 대출비리 사건 수사결과',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 288억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000245',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '19억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '4',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '4'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '국세청(관세청) 보도자료 (2011.11.24)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '국세청(관세청) 보도자료',
      BZC_DSC: '03',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '채무자에게 빌려준 자금을 수표로 상환받아 다시 다른 채무자에게 대여하는 등 자금세탁을 하며 세금 포탈',
      BZC_DSC_NM: '대부업자',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 278억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000235',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '240억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '5',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '5'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '국세청(관세청) 보도자료 (2014.06.25)',
      REL_FNC_CO_C: '03',
      RNDA_DSC: '2',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '국세청(관세청) 보도자료',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: 12,
      JOB_DSC: '4',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '아들이 부(父)의 증권계좌를 장기간 관리하면서 수시로 출금하여 고급오피스텔 전세금 등으로 사용',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 277억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000234',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '분할거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '04',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '5',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '5'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '국세청(관세청) 보도자료 (2014.16.25)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '국세청(관세청) 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자금출처 조사를 회피하기 위해 자산가인 부(父)가 자녀에게 고액 전세금을 증여하고도 자녀가 대출 받아 지급한 것으로 위장한 사례',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 276억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000233',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '15억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '5',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '5'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '국세청(관세청) 보도자료(2014.10.31)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '국세청(관세청) 보도자료',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '3조원대 위장수출 및 재산도피사범 적발 사례',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 275억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000232',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '1',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '07',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '30000억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '5',
      REL_PREM_CRIM_C_NM: '재산국외도피',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '5'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '국세청(관세청) 보도자료 (2009.12.01)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '01',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '국세청(관세청) 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '실제 지출하지 않은 비용을 지출한 양 허위로 장부에 기록하고 비자금 99억원을 조성한 후,  동생 등 가족명의로 부동산을 취득하여 법인세 및 증여세 등을 탈루',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 279억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000236',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '99억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '5',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '5'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '국세청(관세청) 보도자료\r\n(2011.11.24)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '국세청(관세청) 보도자료',
      BZC_DSC: '03',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '채무자에게 빌려준 자금을 수표로 상환받아 다시 다른 채무자에게 대여하는 등 자금세탁을 하며 세금 포탈',
      BZC_DSC_NM: '대부업자',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '오○○외 2인은 제3자를 내세워 수천억대의 자금을 굴리면서 중소기업등을 상대로 고리의 이자를 챙기는 기업형 사채업자로서 금전거래를 숨기기 위해 계약서 없이 기업 등에 빌려준 자금과 이자를 수표로 상환받아 이서하지 않은채 다시 다른 채무자에게 대여하는 등 자금세탁을 거치며 세금을 포탈하고, 주식담보로 코스닥기업 대주주에게 증자대금을 대여하거나, 제3자 명의로 유상증자에 참여하는 방법으로 수백억원대의 자금을 대여하면서 고리의 선이자를 수취하고, 소득세 무신고\r\n\r\n[조치사항]\r\n탈루소득 240억원에 대한 소득세 등 95억원을 추징하고, 범칙처리',
      CPT_WASH_ID: '00000000000000000079',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 계약서 없이 채무자에게 빌려준 자금과 고리 이자를 수표로 상환받아 이서하지 않고, 다른 채무자에게 다시 대여하는 등 자금세탁을 하며 세금을 포탈하고 자금출처를 은닉할 위험\r\n- 이서가 없는 수표사용으로 거래내역을 은폐할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '240',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '5',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '5'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '국세청(관세청) 보도자료\r\n(2014.06.25)',
      REL_FNC_CO_C: '03',
      RNDA_DSC: '2',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '국세청(관세청) 보도자료',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '아들이 부(父)의 증권계좌를 장기간 관리하면서 수시로 출금하여 고급오피스텔 전세금 등으로 사용',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '11',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '고급오피스텔에 전세(12억 원)로 거주하는 아들 C는 뚜렷한 직업이 없는데도 고급 스포츠카(5억 원)를 소유하고 연 1억 원 이상의 신용카드를 사용하는 등의 호화생활을 영위함.\r\n○아들 C는 자산가인 부(父)의 증권계좌를 장기간 관리하며 수시로 운용자금을 출금하는 과정에서 세원포착이 안되도록 수차례 일정규모 단위로 현금을 인출하여,\r\n  - 고급오피스텔의 전세금 및 고급 스포츠카 구입자금 등에 사용함.\r\n\r\n[조치사항]\r\n탈루한 증여금액에 대한 증여세 0억 원을 추징함.',
      CPT_WASH_ID: '00000000000000000078',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '분할거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 자녀에게 증권계좌 관리를 넘기고 자녀가 운영자금을 출금하는 방법으로 증여세를 탈루할 위험\r\n- 일정한 금액으로 나눠 현금을 인출함으로써 보고대상에서 제외될 위험',
      SUSPI_TRTP_C: '04',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '5',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '5'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '국세청(관세청) 보도자료\r\n(2014.16.25)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '국세청(관세청) 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자금출처 조사를 회피하기 위해 자산가인 부(父)가 자녀에게 고액 전세금을 증여하고도 자녀가 대출 받아 지급한 것으로 위장한 사례\r\n',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '08',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '고가주택에 전세(25억 원)로 거주하는 B는 부부소득(1억 원)에 비해 금융대출(15억 원)에 따른 대출이자 부담이 상당한데도 고급 승용차와 유명 헬스클럽 회원권 등을 보유함. 자산가인 부(父)가 결혼한 자녀 B의 고액 전세금 중 일부는 현금 증여하고, 나머지는 자신의 주거래은행과 협의(집주인 동의)하여 자녀B 명의로 전세주택에 근저당을 설정한 후 금융대출을 받아 지급하고, 부(父)가 즉시 금융대출을 상환하고도 근저당권은 해지하지 않아  마치 자녀의 금융대출로 전세주택 전세금을 지급한 것처럼 위장함.\r\n\r\n[조치사항]\r\n탈루한 증여금액에 대한 증여세 0억 원을 추징함.',
      CPT_WASH_ID: '00000000000000000077',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 대출거래를 통해 자녀의 명의로 대출받고 부모가 대신 상환해는 방식으로 재산 증여세 신고 누락 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '15',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '5',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '5'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '국세청(관세청) 보도자료(2014.10.31)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'HK',
      SOUR_TP_C_NM: '국세청(관세청) 보도자료',
      BZC_DSC: '13',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '홍콩',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '3조원대 위장수출 및 재산도피사범 적발 사례',
      BZC_DSC_NM: '무역업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '매출액 1조2천억원대의 무늬만 벤처기업인 ㈜모뉴엘이 상품가치 없는 홈씨어터PC 케이스의 수출가격을 부풀리거나, 실물 이동없이 자체 조작한 허위 해외매출 운송서류를 이용하여 외환은행 등 10여개 은행에서 최근 6년간 총 3조 2천억원의 사기대출을 받았으며, 대출받은 자금을 자신이 관리하는 해외(홍콩) 페이퍼컴퍼니 계좌에 송금한 후 수출채권 매각 대출자금 상환에 사용하지 아니하고 1) 브로커 로비자금 및 현지대여, 2) 차명을 이용해서 자금세탁 후 국내반입, 3)미국 캘리포니아소재 가족용 주택구입, 4)페이퍼컴퍼니명의로 중국공장인수 등의 용도로 사용\r\n[특이사항]\r\n장기간에 걸쳐 적발되지 아니하고 가능했던 이유\r\n- 허위수출의 76%를 해외에서 발생시켜 관계 당국의 감시망을 회피\r\n- 홍콩에 위장조립공장을 만들어 회계감사 및 은행의 실사에 대비\r\n- 과도한 커미션(1.5%~10%)을 지급하는 방법을 통해 대외 신뢰도가 높은 해외 대기업과 거래\r\n- 국내금융기관의 외형적 실적에 의한 여신한도 부여, 수출채권 관련서류의 세밀한 검토 미흡',
      CPT_WASH_ID: '00000000000000000074',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '07',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '- 수출입가격조작, 허위수출채권 매각 등을 통한 사기대출 위험\r\n- 차명계좌를 통한 자금세탁 (위장 수출 -> 위장 수출대금 수령 -> 국내에서 허위 대여약정서 교부)',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '30000',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '5',
      REL_PREM_CRIM_C_NM: '재산국외도피',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '5'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '국세청(관세청) 보도자료\r\n(2009.12.01)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '01',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '국세청(관세청) 보도자료',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '실제 지출하지 않은 비용을 지출한 양 허위로 장부에 기록하고 비자금 99억원을 조성한 후,  동생 등 가족명의로 부동산을 취득하여 법인세 및 증여세 등을 탈루',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '08',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '국내 유명 여성의류 업체인 ㈜△△ 대표 최○○는 2003년부터 2007년까지 회사자금 99억원을 불법 유출하고, 장부에는 원재료 구입대금과 외주가공비를 지불한 것처럼 허위로 계상. 최○○는 유출한 99억원 중 55억원을 동생 등 가족 5인에게 증여. 동생 등은 同 자금으로 제주도, 경기 이천 등 국내 7곳의 고액 경매 부동산을 취득, 양도하였으며, 증여사실을 숨기기 위해 同 금액 만큼 은행 대출을 받아 구입하는 것으로 위장하고, 대출자금은 다른 부동산 구입 등에 사용.\r\n\r\n[조치사항]\r\n해당 기업에게 법인세 등 45억원, 대표자에게 소득세 35억원,  가족에게 증여세 25억, 양도세(경매부동산) 14억원 추징하고, 고발조치.',
      CPT_WASH_ID: '00000000000000000080',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 허위 매출전표를 이용하여 발생한 불법수익을 정상대출로 위장하여 증여세를 탈루할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '99',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '5',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '5'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '언론사례\r\n(2011.11.09)\r\n(http://sbscnbc.sbs.co.kr/read.jsp?pmArticleId=10000310808)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '05',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: 'SK그룹 사건 중 페이퍼컴퍼니를 통한 자금세탁 사례',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: '09',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '검찰과 재계에 따르면 SK그룹 18개 계열사가 창업투자사 베넥스인베스트먼트에 투자한 2천800억원 가운데 SK텔레콤, SK가스 등 5개 계열사 투자금 992억원이 베넥스인베스트먼트 대표 김준홍(46)씨의 차명계좌를 통해 최태원(51) SK그룹 회장의 선물투자를 담당했던 SK해운 고문 출신 역술인 김원홍(50.중국체류)씨에게 흘러들어간 것으로 파악. \r\n- 검찰은 이 돈이 최 회장의 개인 선물투자에 사용된 것으로 보고있으며, 베닉스의 6개 투자업체를 통해 자금세탁이 이루어진 것으로 봄. \r\n- 최 회장의 동생인 최재원(48) SK 수석부회장이 차명계좌를 통해 자금세탁을 거치는 등 돈을 직접 빼돌리는 과정을 주도한 것으로 보고 있으며, 이 과정에 최 회장도 일부 관여했을 개연성이 있다고 판단해 자금 흐름을 집중 조사함',
      CPT_WASH_ID: '00000000000000000089',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 회사자금을 투자 목적으로 다른 회사에 자금을 보낸 뒤 자금세탁을 거쳐 회사자금을 횡령할 위험\r\n- 차명계좌를 통해 해외에 거주하는 타인의  계좌로 자금을 해외도피시킬 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '992',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례\r\n(2010.03.20)\r\n(http://w3.sbs.co.kr/news/newsEndPage.do?news_id=N1000723556)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '강남구청 6급 공무원 공금 횡령 사건',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '강남구청 6급 공무원 이모 씨는 지난해 10월 중순부터 10차례에 걸쳐 공금 7억 7천여만 원을 횡령함. 이 씨가 횡령한 돈은 강남구 공무원 생활안정기금으로 인사팀장인 이 씨가 중간 결재권자였음. \r\n- 주거래 은행에 자신이 전결로 작성한 가짜 공문서를 보내 7억원이 넘는 돈은 이 씨의 증권계좌로 이체되었음\r\n- 문서 보안조치를 통해 다른 직원들이 알 수 없도록 하고, 다른 업무 계좌를 통해 돈세탁을 하였음.',
      CPT_WASH_ID: '00000000000000000090',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '06',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 내부 시스템을 관리하는 직원이 위조된 문서로 은행거래하여 국가 공금을 횡령할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: '7.7',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '주금가장납입 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '03',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례\r\n(2016.02.02)\r\n(http://news.joins.com/article/19513177)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '월 지급식 보험상품을 자녀가 수령하는 사건',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '02',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'A씨는 2년 전 한 보험사의 월 지급식 보험 상품에 가입했다. 그는 설계사(FC)에게 매달 특정일에 자녀가 수백만 원씩 현금으로 대리 수령할 수 있도록 요청했다.\r\n\r\n이에 설계사는 “회사 정책상 통장 계좌를 통해 받는 게 좋다”고 권유했다. 그러나 A씨는 자녀에게 증여를 한 흔적을 남기지 않기 위해 거듭 현금으로 달라고 했고, 설계사는 고객의 의지를 꺾을 수 없었다.',
      CPT_WASH_ID: '00000000000000000091',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '현금에 집착하는 거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 불법증여를 위한 현금 거래',
      SUSPI_TRTP_C: '05',
      TR_SCL_AM: null,
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례\r\n(2016.02.02)\r\n(http://news.joins.com/article/19513177)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '불리한 조건으로 보험사에서 거래하기를 원하는 고객',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'B씨는 최근 한 보험사에서 대출을 받기 위해 지점에 찾아갔다. 창구 상담 직원은 “고객의 조건으로는 은행에서 대출받는 것이 더 좋다”고 솔직하게 말했으나 고객은 막무가내로 이 보험사에서 받고 싶다고 거듭 요구했다.\r\n\r\n게다가 보험사의 대출 기간이 통상적으로 1년임에도 불구하고 1~2개월짜리 단기 대출을 요구했다. B씨는 금융당국의 추적을 피하기 위해 이 보험사를 자금 세탁 중간 경유지로 삼으려 했다.',
      CPT_WASH_ID: '00000000000000000092',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 자금세탁관련 제도가 상대적으로 부족한 보험사',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '03',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례\r\n(2015.01.25)\r\n(http://www.insnews.co.kr/design_php/news_view.php?num=42881&firstsec=1&secondsec=19)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '中 보험시장 ‘검은 돈’ 세탁창구로 악용',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '03',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '옌따빈은 오랜 기간 도로시설물 설치 업체로부터 받은 거액의 뇌물을 깨끗한 돈으로 바꿔야만 했다. 고심 끝에 그는 평소 알고 지내던 보험회사 직원을 불러 부인의 이름으로 저축형 보험상품에 가입했다.\r\n\r\n그는 뇌물로 받은 돈을 보험회사에 잘 묵혀 두면 아무도 돈의 출처를 묻지 않는다는 사실을 알고 있었다. 보험회사 직원도 대충 눈치를 채고 있었으면서도 눈 앞의 거액을 거절하기 어려웠다. 자기가 거절하더라도 그가 다른 보험회사를 찾아갈 것이 뻔했기 때문이다. 옌따빈은 나중에 뇌물을 받은 사실이 들통나자 보험회사에 입금된 돈을 스스로 내놓으면서 법원에 선처를 호소했다.',
      CPT_WASH_ID: '00000000000000000093',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '3',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 차명계좌를 이용한 보험상품 가입',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: null,
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례\r\n(2013.11.13)\r\n(http://www.nocutnews.co.kr/news/1130967)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '10년 연속 \'보험왕\' 알고보니…불법자금 \'세탁창구\'',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'L(69) 씨는 대구와 인천에서 인쇄업체를 운영하며 지난 2003년 1월부터 2008년 5월까지 직원 명의의 차명계좌를 이용해 회삿돈 37억원을 빼돌려 개인 용도로 사용한 혐의를 받고 있다.\r\n캐나다 영주권자인 L 씨는 이렇게 빼돌린 불법 자금을 세무당국의 추적을 피하기 위해 국내 유명 보험사 2곳의 약 600여개 보험상품에 분산 가입한 뒤 234억원 상당을 캐나다로 반출한 것으로 조사됐다. \r\n경찰은 아울러 이처럼 수백억원 상당의 보험상품을 따낸 대가로 L 씨의 부인에게 수억원을 제공한 유명 보험사의 보험 설계사 2명도 함께 검거했다. \r\n특히 ‘10년 연속 전국보험왕’에 오르기도 한 S생명보험사의 Y(58·여) 씨의 경우 L 씨의 보험료 60억5000만원을 빼돌린 혐의로 구속영장을 신청하기로 했다. ',
      CPT_WASH_ID: '00000000000000000094',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 다수의 보험 상품에 분산 가입\r\n- 차명계좌를 이용한 법인자금 유용',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '234',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례\r\n(2016.06.07)\r\n(http://www.koreadaily.com/news/read.asp?art_id=4331417)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'US',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '미국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '1억 달러 보험사기 의사 7명 기소…서류조작 상해보험 허위 과다청구',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '6일 리버사이드카운티 검찰은 제이슨 양(50) 등 7명을 의료비 허위청구, 돈세탁, 문서위조 등 중범죄 혐의 38~69건으로 기소했다고 밝혔다. 검찰은 이들이 계획적으로 서류를 조작해 거액의 의료 보험비를 청구했다고 전했다. \r\n보험사는 가주 보험국과 리버사이드카운티 검찰에 신고했지만 청구한 9800만 달러 중 1240만 달러는 이미 지급된 상태였다. \r\n리버사이드카운티 검찰에 따르면 보험사기 피고인들은 조직적인 팀을 꾸려 종업원 상해보험(워컴) 진료기록을 조작해 각종 의료 보험비를 청구했다. 이들은 주치의나 전문의와 결탁해 과잉진료 및 돈이 많이 드는 검사를 유도했다. 검찰은 이 과정에서 의사가 아닌 무자격자도 개입했다고 전했다. ',
      CPT_WASH_ID: '00000000000000000095',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '2',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 의사가 의료비를 허위청구 및 문서를 위조할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '980',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례\r\n(2016.02.11)\r\n(http://www.koreadaily.com/news/read.asp?art_id=4017951)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '5',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험사기 한인조직 적발…관리책 서모씨, 변호사들 고용 \'작전\' ',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '범죄조직 및 테러단체',
      CPT_WASH_CNTN: 'LA한인타운의 한인 조직은 고의로 차 사고를 내거나 사고가 난 것처럼 꾸며 보험금을 타내는 수법을 사용했다고 폭스방송은 전했다. 일명 \'관리자(administrator)\'로 불리는 한인 여성 서모(37)씨는 차 사고를 당했다고 주장하는 이들을 모집한 뒤 바디샵과 척추병원, 변호사들과 짜고 보험청구 금액을 부풀렸다.\r\n\'S\' 척추병원의 진료 기록에 따르면 사고차량 운전자 단 2명이 무려 52차례나 진료를 받은 것으로 되어 있으며, 이 운전자 2명은 같은 주소에 살고 있는 것으로 나타났다.\r\n\r\n \'관리자\' 서씨는 보험회사와 합의를 위해 변호사들을 직접 고용해 부렸다. \r\n변호사들이 합의금으로 받아낸 수표는 모두 한인 전모씨가 운영하는 타운 8가길 \'B\' 리커에서 체크캐싱을 통해 현금화됐다는 것이다. 방송에 따르면 이 업소에서 월평균 현금화된 수표금액은 300만 달러로 연간 3600만 달러 규모다. 검찰은 돈세탁 혐의로 업주 전씨를 수사중이다.',
      CPT_WASH_ID: '00000000000000000096',
      CUS_CHR_C: '05',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '2',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 고의 사고를 통하여 보험금을 편취할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '30',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '언론사례 (2014.05.09) (http://imnews.imbc.com/replay/2014/nwdesk/article/3460344_13490.html)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '04',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '비영리단체 대출을 이용한 자금세탁 사례',
      BZC_DSC_NM: '귀금속 등 현금집중사업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '신용불량자',
      CPT_WASH_CNTN: 'dddddd',
      CPT_WASH_ID: '00000000000000000215',
      CUS_CHR_C: '02',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: 'dd',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '258억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: null,
      ISR_C: null,
      COP_CHR_C: null,
      SOUR_DTL_CNTN: '언론사례 (2013.10.07) (http://www.hankyung.com/news/app/newsview.php?aid=2013100710341)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: null,
      IV_C_NM: null,
      DWL_TP_C: null,
      LA_C: null,
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: null,
      IV_C: null,
      XLS_SQNO: 12,
      JOB_DSC: null,
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: 'd',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: null,
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 259억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000216',
      CUS_CHR_C: null,
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: null,
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '02',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '662억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사행행위',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례 (2012.08.20) (http://www.hani.co.kr/arti/economy/economy_general/547329.html)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '08',
      IV_C: '2',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '삼환기업 최용권 비자금 사건 중 차명계좌를 통한 횡령, 자금세탁 사례',
      BZC_DSC_NM: '건설업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 260억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000217',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '100억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례 (2012.07.02) (http://biz.heraldcorp.com/view.php?ud=20120702000485)',
      REL_FNC_CO_C: '06',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: null,
      IV_C: '2',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '저축은행이 가짜통장을 이용 예금주 돈을 빼돌린 사건',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 261억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000218',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '180억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '언론사례 (2011.11.09) (http://sbscnbc.sbs.co.kr/read.jsp?pmArticleId=10000310808)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '05',
      IV_C: '2',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: 'SK그룹 사건 중 페이퍼컴퍼니를 통한 자금세탁 사례',
      BZC_DSC_NM: '전문서비스업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'ㅇ',
      CPT_WASH_ID: '00000000000000000219',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '992억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례 (2010.03.20) (http://w3.sbs.co.kr/news/newsEndPage.do?news_id=N1000723556)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '2',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '강남구청 6급 공무원 공금 횡령 사건',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 263억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000220',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '06',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '7.7억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '주금가장납입 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '03',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례 (2016.02.02) (http://news.joins.com/article/19513177)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '월 지급식 보험상품을 자녀가 수령하는 사건',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: 'ㅇ',
      CPT_WASH_ID: '00000000000000000221',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '현금에 집착하는 거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '05',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례 (2016.02.02) (http://news.joins.com/article/19513177)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '불리한 조건으로 보험사에서 거래하기를 원하는 고객',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 265억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000222',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '03',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례 (2015.01.25) (http://www.insnews.co.kr/design_php/news_view.php?num=42881&firstsec=1&secondsec=19)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '中 보험시장 ‘검은 돈’ 세탁창구로 악용',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 266억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000223',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례 (2013.11.13) (http://www.nocutnews.co.kr/news/1130967)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '10년 연속 &apos;보험왕&apos; 알고보니…불법자금 &apos;세탁창구&apos;',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 267억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000224',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '234억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '02',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례 (2016.06.07) (http://www.koreadaily.com/news/read.asp?art_id=4331417)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '1억 달러 보험사기 의사 7명 기소…서류조작 상해보험 허위 과다청구',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 268억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000225',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '980십만불',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례 (2016.02.11) (http://www.koreadaily.com/news/read.asp?art_id=4017951)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '보험사기 한인조직 적발…관리책 서모씨, 변호사들 고용 &apos;작전&apos;',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '범죄조직 및 테러단체',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 269억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000226',
      CUS_CHR_C: '05',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '30십만불',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '01',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례 (2016.08.31) (http://www.yonhapnews.co.kr/bulletin/2016/08/31/0200000000AKR20160831042900004.HTML)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '가짜 사고 꾸며내 보험금 챙긴 보험회사 직원들 검거',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 270억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000227',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '0.467억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례 (2016.03.14) (http://www.yonhapnews.co.kr/bulletin/2016/03/14/0200000000AKR20160314082800054.HTML)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '4',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자매끼리 병원 입원 투어…25억대 일가족 보험사기',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 271억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000228',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '25억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례 (2016.01.28) (http://www.yonhapnews.co.kr/bulletin/2016/01/28/0200000000AKR20160128062500053.HTML)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: null,
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '1',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '"보험설계사가 고객 돈 14억여원 가로채"…경찰 수사',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 272억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000229',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '14.5억원',
      PYM_CHAN_C: '3',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '01',
      SOUR_DTL_CNTN: '언론사례 (2016.03.30) (http://news.sbs.co.kr/news/endPage.do?news_id=N1003497402)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '국내 1대 슈퍼카&apos; 모는 병원장…은밀한 &apos;투잡&apos;',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 273억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000230',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '300억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '언론사례 (2013.04.18) (http://sbscnbc.sbs.co.kr/read.jsp?pmArticleId=10000557171)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '01',
      IV_C: '2',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '해외서버를 두고 인터넷도박 사이트로 얻은 불법수익을 페이퍼컴퍼니를 통해 자금세탁한 사례',
      BZC_DSC_NM: '사행성업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '범죄조직 및 테러단체',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 274억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000231',
      CUS_CHR_C: '05',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '600억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례\r\n(2012.07.02)\r\n(http://biz.heraldcorp.com/view.php?ud=20120702000485)',
      REL_FNC_CO_C: '06',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '14',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '저축은행이 가짜통장을 이용 예금주 돈을 빼돌린 사건',
      BZC_DSC_NM: '비은행 금융기관(은행 이외 제2금융권)',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '브로커 김모(47)씨는 한주저축 이무한(41) 이사의 부탁을 받고 명동의 사채업자를 통해 예금주들을 물색한 뒤 모두 407명을 모집해 한주저축은행에 180억여 원을 저축하게 한 뒤 이 이사로부터 특별이자 명목으로 8억1000만원 상당을 받아 예금주들에게 전달하고, 그 대가로 1억500만원을 받아챙김(특정경제범죄가중처벌법상 횡령ㆍ저축관련부당행위).\r\n- 김 씨는 또 한주저축은행 김임순(53ㆍ여ㆍ구속기소) 대표와 이 이사 등과 짜고 은행 내부 전산프로그램인 ‘테스트모드’를 이용해 통장에 돈이 제대로 입금된 것처럼 조작해 예금주들의 돈 180억여원을 빼돌린 혐의.',
      CPT_WASH_ID: '00000000000000000088',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '다중거래의 동시요청',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '금융기관 대표를 포함한 임직원이 불특정다수를 대상으로 가짜통장을 발급하는 등 금융기관이 사기 및 횡령에 가담할 위험',
      SUSPI_TRTP_C: '11',
      TR_SCL_AM: '180',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례\r\n(2012.08.20)\r\n(http://www.hani.co.kr/arti/economy/economy_general/547329.html)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '08',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '삼환기업 최용권 비자금 사건 중 차명계좌를 통한 횡령, 자금세탁 사례',
      BZC_DSC_NM: '건설업',
      TR_CHR_C: '09',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: ' 삼환기업 최용권(62) 회장 일가가 이중장부를 작성해 회사 돈으로 100억원 상당의 비자금을 조성하고 15개 정도의 차명계좌를 만들어 삼환기업 주식을 보유하거나 관리하는 등 회사 돈으로 비자금을 조성했다는 정황이 비자금을 관리한 내부 직원에 의해 폭로됨. \r\n 최 회장의 비자금을 10년이상 관리했던 경영관리팀 손 전 차장은 최 회장이 2009년 6월 자신과 회사 임원의 이름으로 회사 돈 2억5000만원을 가불하도록 한 뒤 차명계좌를 통해 주식을 사도록 지시했다고 전함. \r\n 최 회장이 차명계좌의 명의자를 변경하는 과정에서 100억원 이상의 증여세를 탈세하고, 차명주식 배당금에 대한 소득세도 포탈, 차명계좌를 통해 삼환기업 주식의 종가를 관리하는 주가조작을 지시해 증권거래법도 위반함. ',
      CPT_WASH_ID: '00000000000000000087',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 차명계좌를 이용한 비자금 조성 등 법인대표 및 임직원이 관련 회사자금을 횡령할 위험\r\n',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '100',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '언론사례\r\n(2013.10.07)\r\n(http://www.hankyung.com/news/app/newsview.php?aid=2013100710341)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'HK',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '13',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '홍콩',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '정보기술 수출업체가 페이퍼컴퍼니를 통해 자금세탁한 사례',
      BZC_DSC_NM: '무역업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '정보기술(IT) 수출업체인 B사는 홍콩 해외 법인에 물건을 싸게 넘겨 홍콩 법인이 막대한 이익을 보게 한 뒤 이익금 662억원을 부인과 아들이 주주인 페이퍼컴퍼니 명의 계좌에 숨겼다. 은닉한 자금 가운데 100억원은 외국인 투자로 가장해 국내 계열사에 투자하거나 다른 국내 상장사 주식을 사다가 당국에 적발됐다. ',
      CPT_WASH_ID: '00000000000000000086',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '- 저가 허위수출신고를 통해 매출을 누락함으로 법인세 등 탈루할 위험\r\n- 해외소득을 해외 페이퍼컴퍼니 명의 비밀계좌에 은닉하여 자금을 세탁할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '662',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '2',
      ISR_C: '01',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례\r\n(2016.08.31)\r\n(http://www.yonhapnews.co.kr/bulletin/2016/08/31/0200000000AKR20160831042900004.HTML)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '가짜 사고 꾸며내 보험금 챙긴 보험회사 직원들 검거',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '보험회사 보상 담당 직원 송모(32)씨와 강모(33)씨는 2015년 10월∼올해 6월 총 4차례에 걸쳐 허위 사고를 지어내 보험금 총 4천670여만을 챙긴 혐의를 받고 있다.\r\n이들은 보상 담당 업무를 맡고 있는 자신들의 권한을 이용, 사고 조사 전산망에 허위 사고를 등록해 별다른 확인 절차 없이 보험금이 지급되도록 만들었다.\r\n멀쩡한 차량에 양초를 칠하고는 사진을 찍어 마치 긁힌 것처럼 조작하고, 가해자 100% 과실인 중앙선 침범이나 후진 추돌사고를 당한 것처럼 사고 개요를 꾸며 최대한 많은 보험금을 타냈다.\r\n또 다른 보상 담당 동료 직원이나 자동차 정비소에서 일하는 대학 동창, 외제차 딜러인 지인, 자동차 정비업체를 운영하는 군대 선임 등 주변 사람들을 가짜 피해자 등으로 내세워 범행에 명의를 사용한 다음 추후 지급된 보험금을 나눠 가졌다.',
      CPT_WASH_ID: '00000000000000000097',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '-보험회사 직원이 허위 사고를 통하여 보험금을 편취할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '.467',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '언론사례\r\n(2014.05.09)\r\n(http://imnews.imbc.com/replay/2014/nwdesk/article/3460344_13490.html)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '04',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '비영리단체 대출을 이용한 자금세탁 사례',
      BZC_DSC_NM: '귀금속 등 현금집중사업',
      TR_CHR_C: '05',
      CUS_CHR_C_NM: '신용불량자',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감\r\n- 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인\r\n- 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 258억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀 없이 21억 원 손실만 봤고, 빚이 자산 보다 80억 원 가까이 많아 직접 대출받지 못한 것. 트라이곤코리아는 빚에 허덕이면서도 빌린 돈을 유 전 회장 가족과 친인척, 계열사에 44억 원을 다시 빌려줌. 또한 단기대여금이 늘고 있는데도 빚을 떼일 것에 대비한 충당금은 거의 쌓지 않았음. \r\n- 유 전 회장 일가가 트라이곤코리아를 통해 구원파 자금을 끌어들인 뒤, 이런 유령 회사를 통해 회삿돈을 빼돌린 것으로 보고 있음',
      CPT_WASH_ID: '00000000000000000085',
      CUS_CHR_C: '02',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '법인자산 또는 타인자산 담보거래',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험\r\n- 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '14',
      TR_SCL_AM: '258',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '04',
      SOUR_DTL_CNTN: '언론사례\r\n(2013.04.18)\r\n(http://sbscnbc.sbs.co.kr/read.jsp?pmArticleId=10000557171)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '2',
      IV_C_NM: '기타 투자 상품 및 서비스',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'CN',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '01',
      IV_C: '2',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '중국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '해외서버를 두고 인터넷도박 사이트로 얻은 불법수익을 페이퍼컴퍼니를 통해 자금세탁한 사례',
      BZC_DSC_NM: '사행성업종',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '범죄조직 및 테러단체',
      CPT_WASH_CNTN: '해외에 서버를 두고 불법 \'스포츠토토\' 사이트를 운영해 6백억원대 부당이득을 챙긴 고모(46)씨 등 8명을 구속 \r\n경찰에 따르면 고씨 등은 2010년 6월부터 최근까지 사설 스포츠토토 사이트 14개에서 인터넷으로 모집한 회원을 상대로 국내외 프로스포츠 경기의 경기 결과에 최대 300만원까지 베팅하게 해 총 6천300여억원을 입금받아 이 가운데 10％상당(600여억원)을 챙긴 혐의.\r\n이들 일당은 경찰 수사망을 피하려 일본에 서버를 두었으며 태국과 중국에 사무실을 열고 현지에서 회원들에게 배당금을 인터넷으로 송금. \r\n또 한국에서 현금으로 출금한 최종 수익금은 유령회사로 추정되는 해외법인에 투자하는 것처럼 꾸며 돈세탁한 것으로 드러남.',
      CPT_WASH_ID: '00000000000000000073',
      CUS_CHR_C: '05',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '해외 여러곳에 사무실을 두고 거래는 인터넷뱅킹을 이용하는 등 수사망을 피해 사행업을 행할 위험\r\n- 불법자금(수익금)에 대해 해외 유령회사 계좌에 은닉하여 탈세 및 자금세탁할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '600',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '01',
      SOUR_DTL_CNTN: '언론사례\r\n(2016.03.30)\r\n(http://news.sbs.co.kr/news/endPage.do?news_id=N1003497402)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '04',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '06',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '2',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '국내 1대 슈퍼카\' 모는 병원장…은밀한 \'투잡\'',
      BZC_DSC_NM: '의료업',
      TR_CHR_C: '08',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '불법 도박으로 벌어들인 엄청난 돈을 세탁하기 위해서 병원까지 차린 일당이 붙잡혔습니다. 국내에는 한 대밖에 없는 고급 외제 차를 몰기도 했습니다.\r\n이들은 지난 2013년부터 최근까지 중국과 홍콩 등지에 사무실을 두고 인터넷 도박사이트를 운영해 왔습니다.\r\n1만 7천여 명의 회원들이 입금한 도박 자금만 2조 6천억 원이나 됐습니다.\r\n우두머리 격인 43살 신 모 씨가 벌어들인 돈은 3백억 원에 달합니다.\r\n신 씨는 3년간 도박사이트를 운영해 얻은 수익으로 세계에서 15대, 국내에는 한 대밖에 없는 고급 외제 차를 타고 다니며 호화 생활을 영위했습니다.\r\n신 씨는 돈세탁을 위해 월급의사를 고용해 병원까지 차렸습니다.\r\n의사 명의로 필요 없는 대출을 받게 하고, 대신 그 대출금을 자신이 현금으로 대납하여 주는 방식으로 자금 세탁했습니다.',
      CPT_WASH_ID: '00000000000000000072',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '09',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 자금세탁을 위해 법인을 설립할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '300',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '범죄수익 은닉 및 가장',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '07',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '언론사례\r\n(2016.01.28)\r\n(http://www.yonhapnews.co.kr/bulletin/2016/01/28/0200000000AKR20160128062500053.HTML)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '16',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '"보험설계사가 고객 돈 14억여원 가로채"…경찰 수사',
      BZC_DSC_NM: '보험업',
      TR_CHR_C: '12',
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '대구 수성경찰서는 A 생명에서 일하는 보험설계사 B(41·여)씨가 고객 6명보험료와 투자금을 빼돌렸다는 내용의 고소장 4건을 접수했다고 28일 밝혔다.\r\nB씨가 2007년부터 최근까지 고객 몰래 보험료를 중도 인출하거나 비공개 투자상품에 투자하라며 투자금을 받아 모두 14억5천여만원을 챙기고는 연락이 끊겼다고 피해자들은 주장하고 있다.\r\nB씨는 자신이 다니는 회사에도 며칠째 출근하지 않는 것으로 전해졌다.\r\n경찰은 "B씨에게 출석 요구를 하고 불응하면 출국금지 등 필요한 조처를 할 계획이다. 피해자가 더 없는지 확인하고 있다"고 말했다.',
      CPT_WASH_ID: '00000000000000000071',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 설계사가 고객의 보험료를 편취할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '14.5',
      PYM_CHAN_C: '3',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '02',
      COP_CHR_C: '08',
      SOUR_DTL_CNTN: '언론사례\r\n(2016.03.14)\r\n(http://www.yonhapnews.co.kr/bulletin/2016/03/14/0200000000AKR20160314082800054.HTML)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '2',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '05',
      NAT_C: 'KR',
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '4',
      REL_NAT_NM: '한국',
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '자매끼리 병원 입원 투어…25억대 일가족 보험사기',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: '10',
      CUS_CHR_C_NM: '무직자',
      CPT_WASH_CNTN: '광주 광산경찰서는 14일 입원 치료가 필요하지 않은 질환을 핑계로 수년 동안 병원 입·퇴원을 반복하며 보험금을 착복한 혐의(사기)로 A(61·여)씨의 세 자매와 친·인척 등 총 11명을 불구속 기소 의견으로 검찰에 송치했다.\r\nA씨 등은 지난 2005년부터 2013년까지 8년여간 광주와 전남·북 병·의원에 허위 입원해 15개 보험사로부터 25억원 상당의 보험금을 부당하게 타낸 혐의를 받고 있다.\r\n이들은 고액의 입원비가 보장되는 건강 보험 상품에 집중 가입한 뒤 협심증과 무릎관절 통증 등을 이유로 병·의원과 요양병원 등 29곳에 입원했고 친·인척끼리 함께 입원해 수시로 외출을 나가 쇼핑과 외식을 하기도 한 것으로 조사됐다.\r\n자매 B(58·여)씨의 경우 지난 8년 사이 57차례 1천226일에 걸쳐 입원했으며 이 중 1천일 이상을 2∼4명의 일가 친인척과 함께 같은 병원에서 입원했던 것으로 확인됐다.\r\n특히 자매 등 가족들과 동일한 기간에 같은 병원에 입·퇴원한 횟수가 55회에 달했다.',
      CPT_WASH_ID: '00000000000000000070',
      CUS_CHR_C: '04',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '기타',
      REL_PREM_CRIM_C: '10',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 불필요한 입퇴원을 반복하여 보험금을 편취할 위험',
      SUSPI_TRTP_C: '17',
      TR_SCL_AM: '25',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '기타',
      ENT_CHAN_C: '5',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: '08',
      COP_CHR_C: '01',
      SOUR_DTL_CNTN: '1',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '01',
      NAT_C: null,
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '01',
      IV_C: '3',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '1',
      ENT_CHAN_C_NM: '다이렉트(인터넷/모바일)',
      CPT_WASH_TI_NM: '1',
      BZC_DSC_NM: '사행성업종',
      TR_CHR_C: '01',
      CUS_CHR_C_NM: 'PEP',
      CPT_WASH_CNTN: null,
      CPT_WASH_ID: '00000000000000000427',
      CUS_CHR_C: '01',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '1',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '1',
      PYM_CHAN_C: '1',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '1',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '1',
      ISR_C: null,
      COP_CHR_C: '01',
      SOUR_DTL_CNTN: '1',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '1',
      IV_C_NM: '펀드',
      DWL_TP_C: '2',
      LA_C: '01',
      NAT_C: null,
      SOUR_TP_C_NM: '언론사례',
      BZC_DSC: '01',
      IV_C: '1',
      XLS_SQNO: null,
      JOB_DSC: '1',
      REL_NAT_NM: '1',
      ENT_CHAN_C_NM: '다이렉트(인터넷/모바일)',
      CPT_WASH_TI_NM: '1',
      BZC_DSC_NM: '사행성업종',
      TR_CHR_C: '01',
      CUS_CHR_C_NM: 'PEP',
      CPT_WASH_CNTN: '1',
      CPT_WASH_ID: '00000000000000000426',
      CUS_CHR_C: '01',
      REL_NAT_RSK_TP_C_NM: '조세피난처 및 마약관련 국가',
      ASET_SCL_C: '1',
      TR_SCL_C: '1',
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '1',
      RSK_CAS_CNTN: '1',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: 'asda',
      PYM_CHAN_C: '1',
      SEL_SOUR_TP_C: '6',
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '1',
      SOUR_TP_C: '6'
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신) 취득경위가 의심스러운 거액예금을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 320억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000277',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: null,
      ISR_C: null,
      COP_CHR_C: null,
      SOUR_DTL_CNTN: null,
      REL_FNC_CO_C: null,
      RNDA_DSC: null,
      IV_C_NM: null,
      DWL_TP_C: null,
      LA_C: null,
      NAT_C: null,
      SOUR_TP_C_NM: null,
      BZC_DSC: null,
      IV_C: null,
      XLS_SQNO: null,
      JOB_DSC: null,
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: null,
      CPT_WASH_TI_NM: '1',
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: null,
      CPT_WASH_CNTN: null,
      CPT_WASH_ID: '00000000000000000425',
      CUS_CHR_C: null,
      REL_NAT_RSK_TP_C_NM: null,
      ASET_SCL_C: null,
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: null,
      RSK_CAS_CNTN: null,
      SUSPI_TRTP_C: null,
      TR_SCL_AM: null,
      PYM_CHAN_C: null,
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: null,
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신) 취득경위가 의심스러운 거액예금을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 322억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000279',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '4억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)취득경위가 의심되는 부동산을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 323억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000280',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)경제적 합리성 없이 제3자의 부동산을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 324억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000281',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)경제적 합리성 없이 제3자의 부동산을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 325억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000282',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)대표이사가 동일한 외감대상 규모 미만의 소규모 법인으로 합리적 이유없이 동 법인상호간 담보제공하고 대출하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 326억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000283',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)대표자에게 실질적 경영��이 없는 것으로 의심되거나 위장 법인이  합리적 이유 없이 거액을 대출받는 거래 1',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 327억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000284',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)대표자에게 실질적 경영권이 없는 것으로 의심되거나 위장 법인이  합리적 이유 없이 거액을 대출받는 거래 2',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 328억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000285',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: 'KoFIU사례_연차보고서 (2007) P.88~89',
      REL_FNC_CO_C: '06',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '08',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '2',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '건설업체대표의 불법대출 사례',
      BZC_DSC_NM: '건설업',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 291억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000248',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '1',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '313억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)거액의 신규대출 후 합리적 이유 없이 단기간 내 현금 등으로 상환하는 거래 1',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 329억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000286',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '원격지거래',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '02',
      TR_SCL_AM: '2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)거액의 신규대출 후 합리적 이유 없이 단기간 내 현금 등으로 상환하는 거래 2',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 330억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000287',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '원격지거래',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '02',
      TR_SCL_AM: '3억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)거액의 대출을 경제적 합리성 없는 제3자가 대리인 자격으로 상환하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 331억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000288',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)장기간 연체된 대출금을 합리적 이유 없이 상환하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 332억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000289',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '2억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)미성년자 명의의 채무인수거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 333억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000290',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '6역원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)거래의 목적이 의심되는 법인보유 상장 유가증권 담보대출거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 334억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000291',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '3억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)대표이사 및 최대주주의 변경이 빈번한 법인의 합리적 이유없는 담보대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 335억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000292',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '5억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)법인의 담보를 이용한 특수관계인 명의 대출금 상환거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 336억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000293',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '4억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적 이유 없이 계약체결 후 단기간 내에 해약하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 337억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000294',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '현금에 집착하는 거래',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '05',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 수회에 걸쳐 집중적으로 보험 계약대출을 받은 후 곧바로 해약하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 338억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000295',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 계약자의 직업, 재산상태 등에 비추어 특별한 사유 없이 고액의 보험계약을 체결하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 339억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000296',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 보험금 수령 후 계약자, 피보험자가 아닌 제3자에게 거액을 송금  의뢰하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 340억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000297',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적 사유 없이 보험계약 체결 후 비교적 단기간 내에 고액의 보험료를 선납하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 341억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000298',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '분할거래',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '04',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 고액의 보험료가 일정한 관계가 없는 타인의 통장에서 지속적으로 납입되는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 342억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000299',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '1',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 대표이사 등이 법인 명의 계약에 대하여 현금 등으로 중도인출',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 343억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000300',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 법인 명의 계약체결 후 법인대표로 계약자를 변경하고 해지 후 현금 수령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 344억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000301',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 보험을 이용한 탈세 의심 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 345억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000302',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '현금에 집착하는 거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '05',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 보험을 이용한 탈세 의심 거래 2',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 346억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000303',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '1억원',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 계약체결 후 단기간 내에 고액의 보험계약대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 347억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000304',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 보험계약대출과 상환을 반복하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 348억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000305',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 대출금을 단기간 내에 상환하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 349억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000306',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 대출금리 등 타 금융기관의 대출이 유리함에도 합리적 이유없이 특정 금융기관과 대출을 고집하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 350억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000307',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 부활 후 해약 또는 고액의 계약대출을 실행하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 351억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000308',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 부활 후 해약 또는 고액의 계약대출을 실행하는 거래2',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 352억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000309',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 고액의 보험을 가입하면서 자금세탁방지제도에 관하여 문의하는  거래(I)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 353억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000310',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 고액의 보험을 가입하면서 자금세탁방지제도에 관하여 문의하는 거래(Ⅱ)',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 354억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000311',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 실효된 계약을 타 지역 설계사에게 부활 요청하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 355억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000312',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '원격지거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '02',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_협의거래 참고유형',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 경제적 능력이 의심되는 보험계약자가 거액의 보험료를 일시에 납입하고, 만기 또는 사망시 수익자를 이해관계 없는 제3자로 지정한 경우',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 356억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000313',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신)상품단가 조작을 통해 부풀려진 수출매출채권의 할인',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 368억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000325',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '04',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '허위매출전표 작성 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험)합리적 이유없이 계약체결 후 단기간 내에 해약하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 369억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000326',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 법인 명의 계약체결 후 법인대표로 계약자를 변경하고 해지 후 현금 수령',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 370억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000327',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '1',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 보험을 이용한 탈세 의심 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 371억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000328',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: 'TM',
      CPT_WASH_TI_NM: '(보험)여러 기업을 거느린 오너가 다수의 계열사들로 하여금 자신을 피보험자로 하는 고액의 저축성 보험을 체결하게 하는 행위',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 372억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000329',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '분할거래',
      REL_PREM_CRIM_C: '01',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '04',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '조세포탈',
      ENT_CHAN_C: '2',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '02',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(보험) 합리적인 이유 없이 보험계약대출과 상환을 반복하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 373억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000330',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: '03',
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: '사기/횡령/배임 등',
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-상호저축은행)(여신)취득경위에 의심이 가는 타인명의 재산을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 374억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000331',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '현금에 집착하는 거래',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '05',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-상호저축은행)(여신)사업자등록증의 위∙변조를 통한 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 375억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000332',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-상호저축은행)(여신)빈번한 예금 담보대출을 이용하는 금융거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 376억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000333',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-상호저축은행)(여신)합리적 이유없이 장기간 연체된 대출금을 갑자기 상환하는 경우',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 377억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000334',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-새마을금고)(여신)취득경위에 의심이 있는 거액을 정기예금하고 범위 내 대출을 요구하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 378억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000335',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '1',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-새마을금고)(여신)타인명의 재산을 담보로 거액의 대출을 받는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 379억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000336',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-새마을금고)(여신)자금출처가 명확치 않은 거액의 현금을 대출금 상환에 이용한 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 380억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000337',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-새마을금고)(여신)고액의 신규대출 거래를 신청하면서 회원가입신청서, 신용조사서 등 각종 기재사항의 기록을 회피하는 경우',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 381억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000338',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '현금에 집착하는 거래',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '05',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '4',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-신용협동조합)(여신)담보가 있는 일반대출이 연체가 되어 독촉을 하자 채무자와 이해관계가 있는 자가 대위변제를 하는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 382억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0011\u0000\u0000\u0000\u0005\u0000\u0011\u0000\u0011\u0000\u000B\u0000\u0010\u0000\u0012\u0000\u0012\u0000\u0000\u0000\u0005\u0000\u0012\u0000\u0012\u0000\u000B\u0000\u0010\u0000\u0013\u0000\u0013\u0000\u0000\u0000\u0005\u0000\u0013\u0000\u0013\u0000\u000B\u0000\u0010\u0000\u0014\u0000\u0014\u0000\u0000\u0000\u0005\u0000\u0014\u0000\u0014\u0000\u000B\u0000\u0010\u0000\u0015\u0000\u0015\u0000\u0000\u0000\u0005\u0000\u0015\u0000\u0015\u0000\u000B\u0000\u0010\u0000\u0016\u0000\u0016\u0000\u0000\u0000\u0005\u0000\u0016\u0000\u0016\u0000\u000B\u0000\u0010\u0000\u0017\u0000\u0017\u0000\u0000\u0000\t\u0000\u0017\u0000\u0017\u0000\u000B\u0000\u0010\u0000\u0007\u0000\u0007\u0000\t\u0000\t\u0000\b\u0000\b\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000\t\u0000 \u0000 \u0000\t\u0000\t\u0000\u000B\u0000\u000B\u0000\t\u0000\t\u0000\f\u0000\f\u0000\t\u0000\t\u0000\u0000\u0000\t\u0000\t\u0000\u000E\u0000\u000E\u0000\t\u0000\t\u0000\u000F\u0000\u000F\u0000\t\u0000\t\u0000\u0010\u0000\u0010\u0000\t\u0000\t\u0000\u0011\u0000\u0011\u0000\t\u0000\t\u0000\u0012\u0000\u0012\u0000\t\u0000\t\u0000\u0013\u0000\u0013\u0000\t\u0000\t\u0000\u0014\u0000\u0014\u0000\t\u0000\t\u0000\u0015\u0000\u0015\u0000\t\u0000\t\u0000\u0016\u0000\u0016\u0000',
      CPT_WASH_ID: '00000000000000000339',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: null,
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '의심거래 참고유형 (2015)',
      REL_FNC_CO_C: '07',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(소형금융기관-신용협동조합)(여신)소규모 점포에서 합리적인 이유 없이 여신 거래금액의 규모가 커지는 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 383억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000340',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '갑작스러운 거래패턴의 변화',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '01',
      TR_SCL_AM: '알 수 없음',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: null,
      ISR_C: null,
      COP_CHR_C: null,
      SOUR_DTL_CNTN: null,
      REL_FNC_CO_C: null,
      RNDA_DSC: null,
      IV_C_NM: null,
      DWL_TP_C: null,
      LA_C: null,
      NAT_C: null,
      SOUR_TP_C_NM: null,
      BZC_DSC: null,
      IV_C: null,
      XLS_SQNO: null,
      JOB_DSC: null,
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: null,
      CPT_WASH_TI_NM: null,
      BZC_DSC_NM: null,
      TR_CHR_C: null,
      CUS_CHR_C_NM: null,
      CPT_WASH_CNTN: null,
      CPT_WASH_ID: '00000000000000000424',
      CUS_CHR_C: null,
      REL_NAT_RSK_TP_C_NM: null,
      ASET_SCL_C: null,
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: null,
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: null,
      RSK_CAS_CNTN: null,
      SUSPI_TRTP_C: null,
      TR_SCL_AM: null,
      PYM_CHAN_C: null,
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: null,
      SOUR_TP_C: null
    },
    {
      RELFRE_TP_C: '3',
      ISR_C: '08',
      COP_CHR_C: '07',
      SOUR_DTL_CNTN: '기타_혐의거래 참고유형',
      REL_FNC_CO_C: '01',
      RNDA_DSC: '3',
      IV_C_NM: 'N/A',
      DWL_TP_C: '2',
      LA_C: '03',
      NAT_C: 'KR',
      SOUR_TP_C_NM: null,
      BZC_DSC: '18',
      IV_C: '3',
      XLS_SQNO: 12,
      JOB_DSC: '5',
      REL_NAT_NM: null,
      ENT_CHAN_C_NM: '기타 가입채널',
      CPT_WASH_TI_NM: '(여신) 취득경위가 의심스러운 거액예금을 담보로 하는 대출 거래',
      BZC_DSC_NM: '기타 업종',
      TR_CHR_C: null,
      CUS_CHR_C_NM: '기타 고객특성',
      CPT_WASH_CNTN: '구원파 신도들이 조합원으로 참여한 신용협동조합의 대출금이 종교단체를 거쳐 유병언 전 세모 회장 일가의 건설사인 트라이곤코리아로 흘러들어감 - 구원파 신도들의 2백억대 자금이 복잡한 세탁을 거쳐 유병언 전 회장 일가로 흘러들어간 사실을 금융당국이 확인 - 구원파 돈이 들어간 A 신협에서 기독교복음침례회가 321억원 대출을 받았고, 이 돈이 다시 트라이곤코리아로 흘러들어가면서 억대의 이자 등 원리금은 트라이곤코리아가 대신 갚고 있었음.  지난해 매출은 전혀\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
      CPT_WASH_ID: '00000000000000000278',
      CUS_CHR_C: '06',
      REL_NAT_RSK_TP_C_NM: '기타국가',
      ASET_SCL_C: '2',
      TR_SCL_C: null,
      SUSPI_TRTP_C_NM: '의심스러운 담보대출 또는 보험계약 즉시 약관대출',
      REL_PREM_CRIM_C: null,
      REL_NAT_RSK_TP_C: '6',
      RSK_CAS_CNTN: '- 비영리단체가 자금세탁에 이용될 위험 - 페이퍼컴퍼니를 통하여 자금을 은닉할 위험',
      SUSPI_TRTP_C: '09',
      TR_SCL_AM: '3억원',
      PYM_CHAN_C: '5',
      SEL_SOUR_TP_C: null,
      REL_PREM_CRIM_C_NM: null,
      ENT_CHAN_C: '5',
      SOUR_TP_C: null
    }
  ]

};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
